drop table nc_animalspecies ;

create table nc_animalspecies(
    uniqueid       bigint    not null,
    tableid        bigint    not null,
    owner          bigint    not null,
    modtime timestamp not null,
    moduser        bigint    not null,
    name           varchar(128)    not null,
    strain         varchar(128),
    latinname      varchar(128),
    description    text,
    constraint nc_animalspecies_pk primary key (uniqueid) ,
    constraint nc_animalspecies_sk  unique (tableid, uniqueid) );

-- comment on table nc_animalspecies is 'the nc_animalspecies table provides the information to classify the species of a research subject (i.e. for the nc_researchsubject table and its children, e.g. nc_humansubject).' ;

-- comment on column nc_animalspecies.uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_animalspecies.tableid is 'the tableid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the uniqueid column these two columns specify a global unique object/tuple identifier within the database.   this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the tableid also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.' ;

-- comment on column nc_animalspecies.owner is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_animalspecies.modtime is 'the modtimecolumn is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the moduser column these two columns specify who entered the data (moduser) and when (modtime).  taken together with a core table (nc_tablename) and its backing table (bk_tablename which is used to store the history of changes to a tuple) modtime allows one to fully recreate the history of every tuple stored in a core table.' ;

-- comment on column nc_animalspecies.moduser is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_animalspecies.name is 'the name column is used for the common name of a species.' ;

-- comment on column nc_animalspecies.strain is 'the straincolumn is used for the name of the strain of a species.' ;

-- comment on column nc_animalspecies.latinname is 'the latinname column is used for the common name of a species. ' ;

-- comment on column nc_animalspecies.description is 'the description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.' ;

