drop table nc_assessmentboolean ;

create table nc_assessmentboolean(
    tableid                           bigint    not null,
    nc_assessmentdata_uniqueid        bigint    not null,
    scoreorder                        bigint    not null,
    owner                             bigint    not null,
    modtime timestamp not null,
    moduser                           bigint    not null,
    textvalue                         varchar(255),
    textnormvalue                     varchar(255),
    comments                          text,
    datavalue                         boolean,
    datanormvalue                     boolean,
    storedassessmentid                bigint    not null,
    assessmentid                      bigint    not null,
    scorename                         varchar(128)    not null,
    scoretype                         varchar(64)     not null,
    isvalidated                       boolean      default false not null,
    isranked                          boolean      default false not null,
    subjectid                         varchar(64)     not null,
    entryid                           bigint,
    keyerid                           bigint,
    raterid                           bigint,
    classification                    bigint,
    nc_dataclassification_uniqueid    bigint,
    uniqueid                          bigint,
    constraint nc_assessmentboolean_pk primary key (tableid, nc_assessmentdata_uniqueid) ,
    constraint nc_assessmentboolean_sk  unique (nc_assessmentdata_uniqueid, tableid) );

-- comment on table nc_assessmentboolean is 'the assessmentboolean table stores all boolean scores for an assessment.' ;

-- comment on column nc_assessmentboolean.tableid is 'the tableid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the uniqueid column these two columns specify a global unique object/tuple identifier within the database.   this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the tableid also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.' ;

-- comment on column nc_assessmentboolean.nc_assessmentdata_uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_assessmentboolean.scoreorder is 'the sequencestep domain is used to represent the stage (or step) in a sequence of events. for example an experimental condition (i.e. nc_expcondition) that starts on the second segment and finishes on the fourth would have a start value of 2 and an end value of 4. ' ;

-- comment on column nc_assessmentboolean.owner is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_assessmentboolean.modtime is 'the modtimecolumn is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the moduser column these two columns specify who entered the data (moduser) and when (modtime).  taken together with a core table (nc_tablename) and its backing table (bk_tablename which is used to store the history of changes to a tuple) modtime allows one to fully recreate the history of every tuple stored in a core table.' ;

-- comment on column nc_assessmentboolean.moduser is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_assessmentboolean.textvalue is 'the textvalue column is used to store the textual representations of data from all types.  this provides an easy way to return the results from queries selecting values of diffferent types without the need for conversion.' ;

-- comment on column nc_assessmentboolean.textnormvalue is 'the textvalue column is used to store the textual representations of data from all types.  this provides an easy way to return the results from queries selecting values of diffferent types without the need for conversion.' ;

-- comment on column nc_assessmentboolean.comments is 'the description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.' ;

-- comment on column nc_assessmentboolean.datavalue is 'the booleandata domain is used to hold native boolean data.' ;

-- comment on column nc_assessmentboolean.datanormvalue is 'the booleandata domain is used to hold native boolean data.' ;

-- comment on column nc_assessmentboolean.storedassessmentid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_assessmentboolean.assessmentid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_assessmentboolean.scorename is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_assessmentboolean.scoretype is 'the type column describes the data type of the object being described by the tuple.' ;

-- comment on column nc_assessmentboolean.isvalidated is 'the istrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  the default representation of the domain is that if the value is 1, then the field is true.  the name of the field should be descriptive (e.g. is*condition* true).' ;

-- comment on column nc_assessmentboolean.isranked is 'the istrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  the default representation of the domain is that if the value is 1, then the field is true.  the name of the field should be descriptive (e.g. is*condition* true).' ;

-- comment on column nc_assessmentboolean.subjectid is 'the investigator id for the research subject.' ;

-- comment on column nc_assessmentboolean.entryid is 'the sequencestep domain is used to represent the stage (or step) in a sequence of events. for example an experimental condition (i.e. nc_expcondition) that starts on the second segment and finishes on the fourth would have a start value of 2 and an end value of 4. ' ;

-- comment on column nc_assessmentboolean.keyerid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_assessmentboolean.raterid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_assessmentboolean.nc_dataclassification_uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_assessmentboolean.uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

