drop table nc_assessmentdata ;

create table nc_assessmentdata(
    tableid                         bigint    not null,
    uniqueid                        bigint    not null,
    scoreorder                      bigint    not null,
    owner                           bigint    not null,
    modtime timestamp not null,
    moduser                         bigint    not null,
    assessmentid                    bigint    not null,
    scorename                       varchar(128)    not null,
    scoretype                       varchar(64)     not null,
    textvalue                       varchar(255),
    textnormvalue                   varchar(255),
    encrypted                       boolean     not null,
    comments                        text,
    nc_storedassessment_uniqueid    bigint    not null,
    isvalidated                     boolean      default false not null,
    isranked                        boolean      default false not null,
    subjectid                       varchar(64)     not null,
    entryid                         bigint    not null,
    keyerid                         bigint,
    raterid                         bigint,
    classification                  bigint,
    constraint nc_assessmentdata_pk primary key (tableid, uniqueid) ,
    constraint nc_assessmentdata_sk  unique (tableid, uniqueid, assessmentid) );

-- comment on column nc_assessmentdata.tableid is 'the table identifier for all data stored within this table.  in conjunction with a unique id creates a unique reference to all tuples within the database for tuple level access control.' ;

-- comment on column nc_assessmentdata.uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_assessmentdata.scoreorder is 'the sequencestep domain is used to represent the stage (or step) in a sequence of events. for example an experimental condition (i.e. nc_expcondition) that starts on the second segment and finishes on the fourth would have a start value of 2 and an end value of 4. ' ;

-- comment on column nc_assessmentdata.owner is 'the database user who who owns the selected tuple.  this could be the user who created the entry or the user who manages/oversees the user who entered the tuple.' ;

-- comment on column nc_assessmentdata.modtime is 'the modification time of the current entry (year to fraction(5)).' ;

-- comment on column nc_assessmentdata.moduser is 'the user who modified the current tuple entry.  this can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.' ;

-- comment on column nc_assessmentdata.assessmentid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_assessmentdata.scorename is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_assessmentdata.scoretype is 'the type column describes the data type of the object being described by the tuple.' ;

-- comment on column nc_assessmentdata.textvalue is 'the textvalue column is used to store the textual representations of data from all types.  this provides an easy way to return the results from queries selecting values of diffferent types without the need for conversion.' ;

-- comment on column nc_assessmentdata.textnormvalue is 'the textvalue column is used to store the textual representations of data from all types.  this provides an easy way to return the results from queries selecting values of diffferent types without the need for conversion.' ;

-- comment on column nc_assessmentdata.encrypted is 'the istrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  the default representation of the domain is that if the value is 1, then the field is true.  the name of the field should be descriptive (e.g. is*condition* true).' ;

-- comment on column nc_assessmentdata.comments is 'the description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.' ;

-- comment on column nc_assessmentdata.nc_storedassessment_uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_assessmentdata.isvalidated is 'the istrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  the default representation of the domain is that if the value is 1, then the field is true.  the name of the field should be descriptive (e.g. is*condition* true).' ;

-- comment on column nc_assessmentdata.isranked is 'the istrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  the default representation of the domain is that if the value is 1, then the field is true.  the name of the field should be descriptive (e.g. is*condition* true).' ;

-- comment on column nc_assessmentdata.subjectid is 'the investigator id for the research subject.' ;

-- comment on column nc_assessmentdata.entryid is 'the sequenceid domain is used to define an ordered sequence of entries or objects (e.g. visits by a subject).  the sequence begins with 1.' ;

-- comment on column nc_assessmentdata.keyerid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_assessmentdata.raterid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_assessmentdata.classification is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

