drop table nc_dataobject ;

create table nc_dataobject(
    uniqueid         bigint,
    tableid          bigint    not null,
    owner            bigint    not null,
    modtime timestamp not null,
    moduser          bigint    not null,
    extensionname    varchar(18)     not null,
    dataid           bigint,
    objecttypeid     bigint     not null,
    objectname	     varchar(256),
    objectsize       bigint not null,
    description      varchar(256),
    constraint nc_dataobject_sk  unique (uniqueid, tableid) );

-- comment on column nc_dataobject.uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_dataobject.tableid is 'the tableid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the uniqueid column these two columns specify a global unique object/tuple identifier within the database.   this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the tableid also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.' ;

-- comment on column nc_dataobject.owner is 'the database user who who owns the selected tuple.  this could be the user who created the entry or the user who manages/oversees the user who entered the tuple.' ;

-- comment on column nc_dataobject.modtime is 'the modification time of the current entry (year to fraction(5)).' ;

-- comment on column nc_dataobject.moduser is 'the user who modified the current tuple entry.  this can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.' ;

-- comment on column nc_dataobject.dataid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_dataobject.description is 'the description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.' ;

