drop table nc_deriveddata ;

create table nc_deriveddata(
    uniqueid                  bigint     not null,
    tableid                   bigint     not null,
    owner                     bigint     not null,
    modtime timestamp not null,
    moduser                   bigint     not null,
    extensionname             varchar(128)      default 'deriveddata' not null,
    datauri                   varchar(2048),
    israw                     boolean       default false not null,
    ontologysource            varchar(128)     not null,
    conceptid                 varchar(64)      not null,
    segmentid                 bigint,
    componentid               bigint,
    nc_experiment_uniqueid    bigint,
    subjectid                 varchar(64)      not null,
    isbad                     boolean       default false not null,
    constraint nc_deriveddata_pk primary key (uniqueid) ,
    constraint nc_deriveddata_sk  unique (uniqueid, tableid) );

-- comment on column nc_deriveddata.uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_deriveddata.tableid is 'the table identifier for all data stored within this table.  in conjunction with a unique id creates a unique reference to all tuples within the database for tuple level access control.' ;

-- comment on column nc_deriveddata.owner is 'the database user who who owns the selected tuple.  this could be the user who created the entry or the user who manages/oversees the user who entered the tuple.' ;

-- comment on column nc_deriveddata.modtime is 'the modification time of the current entry (year to fraction(5)).' ;

-- comment on column nc_deriveddata.moduser is 'the user who modified the current tuple entry.  this can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.' ;

-- comment on column nc_deriveddata.extensionname is 'the extensionname column is used in inheritance hierarchies to name the object (i.e. the table) a tuple is associated with.  this should default to the name of the table.' ;

-- comment on column nc_deriveddata.datauri is 'the uri column references the object being described by the tuple.  for data objects, for example, the uri can reference either an individual object (e.g. file or document) or an entire collection (e.g. directory of dicom images).    a uniform resource identifier (uri) is a compact sequence of characters that identifies an abstract or physical resource.  the standard for uris can be found at: http://www.ietf.org/rfc/rfc3986.txt' ;

-- comment on column nc_deriveddata.israw is 'the istrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  the default representation of the domain is that if the value is 1, then the field is true.  the name of the field should be descriptive (e.g. is*condition* true).' ;

-- comment on column nc_deriveddata.ontologysource is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_deriveddata.conceptid is 'the varcharid domain is used to represent alphanumeric identifiers (e.g. the id of a research subject in a laboratory).' ;

-- comment on column nc_deriveddata.segmentid is 'the sequential id of the visit segment. for example during a scanning visit each scan would be sequentially numbered.' ;

-- comment on column nc_deriveddata.componentid is 'the sequenceid domain is used to define an ordered sequence of entries or objects (e.g. visits by a subject).  the sequence begins with 1.' ;

-- comment on column nc_deriveddata.nc_experiment_uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_deriveddata.subjectid is 'the investigator id for the research subject.' ;

-- comment on column nc_deriveddata.isbad is 'the istrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  the default representation of the domain is that if the value is 1, then the field is true.  the name of the field should be descriptive (e.g. is*condition* true).' ;

