drop table nc_expcomponent ;

create table nc_expcomponent(
    componentid               bigint       not null,
    nc_experiment_uniqueid    bigint       not null,
    subjectid                 varchar(64)        not null,
    uniqueid                  bigint       not null,
    tableid                   bigint       not null,
    owner                     bigint       not null,
    modtime timestamp not null,
    moduser                   bigint       not null,
    time_stamp                timestamp(6)        not null,
    description               text,
    visittype                 varchar(64)        not null,
    name                      varchar(128),
    timeinterval              double precision     default 0,
    istimeinterval            boolean,
    check (componentid > 0),
    constraint nc_expcomponent_pk primary key (componentid, nc_experiment_uniqueid, subjectid) ,
    constraint nc_expcomponent_sk  unique (uniqueid, tableid) );

-- comment on column nc_expcomponent.componentid is 'the sequential identifier for a subject clinical or scanner visit' ;

-- comment on column nc_expcomponent.nc_experiment_uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_expcomponent.subjectid is 'the investigator id for the research subject.' ;

-- comment on column nc_expcomponent.uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_expcomponent.tableid is 'the table identifier for all data stored within this table.  in conjunction with a unique id creates a unique reference to all tuples within the database for tuple level access control.' ;

-- comment on column nc_expcomponent.owner is 'the database user who who owns the selected tuple.  this could be the user who created the entry or the user who manages/oversees the user who entered the tuple.' ;

-- comment on column nc_expcomponent.modtime is 'the modification time of the current entry (year to fraction(5)).' ;

-- comment on column nc_expcomponent.moduser is 'the user who modified the current tuple entry.  this can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.' ;

-- comment on column nc_expcomponent.time_stamp is 'the date and time of the visit.' ;

-- comment on column nc_expcomponent.description is 'textual description of the visit.' ;

-- comment on column nc_expcomponent.visittype is 'the name of the visit type (e.g. ''clinical'' or ''scan'')' ;

-- comment on column nc_expcomponent.name is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_expcomponent.istimeinterval is 'the istrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  the default representation of the domain is that if the value is 1, then the field is true.  the name of the field should be descriptive (e.g. is*condition* true).' ;

