drop table nc_expsegment ;

create table nc_expsegment(
    segmentid                 bigint       not null,
    componentid               bigint       not null,
    nc_experiment_uniqueid    bigint       not null,
    subjectid                 varchar(64)        not null,
    uniqueid                  bigint       not null,
    tableid                   bigint       not null,
    owner                     bigint       not null,
    modtime timestamp not null,
    moduser                   bigint       not null,
    time_stamp                timestamp(6)        not null,
    description               text,
    protocolversion           bigint        default 1 not null,
    protocolid                varchar(64)        not null,
    studyid                   bigint,
    name                      varchar(128),
    istimeinterval            boolean         default false not null,
    timeinterval              double precision,
    isbad                     boolean         default false not null,
    constraint nc_expsegment_pk primary key (segmentid, componentid, nc_experiment_uniqueid, subjectid) ,
    constraint nc_expsegment_sk  unique (uniqueid, tableid) );

-- comment on column nc_expsegment.segmentid is 'the sequential id of the visit segment. for example during a scanning visit each scan would be sequentially numbered.' ;

-- comment on column nc_expsegment.componentid is 'the sequenceid domain is used to define an ordered sequence of entries or objects (e.g. visits by a subject).  the sequence begins with 1.' ;

-- comment on column nc_expsegment.nc_experiment_uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_expsegment.subjectid is 'the investigator id for the research subject.' ;

-- comment on column nc_expsegment.uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_expsegment.tableid is 'the table identifier for all data stored within this table.  in conjunction with a unique id creates a unique reference to all tuples within the database for tuple level access control.' ;

-- comment on column nc_expsegment.owner is 'the database user who who owns the selected tuple.  this could be the user who created the entry or the user who manages/oversees the user who entered the tuple.' ;

-- comment on column nc_expsegment.modtime is 'the modification time of the current entry (year to fraction(5)).' ;

-- comment on column nc_expsegment.moduser is 'the user who modified the current tuple entry.  this can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.' ;

-- comment on column nc_expsegment.time_stamp is 'the timestamp domain is used to notate the date and time of an occurence (e.g. a subject visit, nc_expcomponent).  the timestamp refers to the beginning (start) time for the object.' ;

-- comment on column nc_expsegment.description is 'the description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.' ;

-- comment on column nc_expsegment.protocolversion is 'the versionid domain is used to denote version identifiers. these identifiers can have major and minor revisions.' ;

-- comment on column nc_expsegment.protocolid is 'the varcharid domain is used to represent alphanumeric identifiers (e.g. the id of a research subject in a laboratory).' ;

-- comment on column nc_expsegment.studyid is 'the sequential id of the visit segment. for example during a scanning visit each scan would be sequentially numbered.' ;

-- comment on column nc_expsegment.name is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_expsegment.istimeinterval is 'the istrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  the default representation of the domain is that if the value is 1, then the field is true.  the name of the field should be descriptive (e.g. is*condition* true).' ;

-- comment on column nc_expsegment.isbad is 'the istrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  the default representation of the domain is that if the value is 1, then the field is true.  the name of the field should be descriptive (e.g. is*condition* true).' ;

