drop table nc_expstudy ;

create table nc_expstudy(
    studyid           bigint       not null,
    componentid       bigint       not null,
    experimentid      bigint       not null,
    subjectid         varchar(64)        not null,
    uniqueid          bigint       not null,
    tableid           bigint       not null,
    owner             bigint       not null,
    modtime timestamp not null,
    moduser           bigint       not null,
    time_stamp        timestamp(6)        not null,
    description       text,
    name              varchar(128),
    istimeinterval    boolean         default false not null,
    timeinterval      double precision,
    constraint nc_expstudy_pk primary key (studyid, componentid, experimentid, subjectid) ,
    constraint nc_expstudy_sk  unique (uniqueid, tableid) );

-- comment on column nc_expstudy.studyid is 'the sequential id of the visit segment. for example during a scanning visit each scan would be sequentially numbered.' ;

-- comment on column nc_expstudy.componentid is 'the sequential identifier for a subject clinical or scanner visit' ;

-- comment on column nc_expstudy.experimentid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_expstudy.subjectid is 'the investigator id for the research subject.' ;

-- comment on column nc_expstudy.uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_expstudy.tableid is 'the tableid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the uniqueid column these two columns specify a global unique object/tuple identifier within the database.   this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the tableid also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.' ;

-- comment on column nc_expstudy.owner is 'the database user who who owns the selected tuple.  this could be the user who created the entry or the user who manages/oversees the user who entered the tuple.' ;

-- comment on column nc_expstudy.modtime is 'the modification time of the current entry (year to fraction(5)).' ;

-- comment on column nc_expstudy.moduser is 'the user who modified the current tuple entry.  this can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.' ;

-- comment on column nc_expstudy.time_stamp is 'the timestamp domain is used to notate the date and time of an occurence (e.g. a subject visit, nc_expcomponent).  the timestamp refers to the beginning (start) time for the object.' ;

-- comment on column nc_expstudy.description is 'the description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.' ;

-- comment on column nc_expstudy.name is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_expstudy.istimeinterval is 'the istrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  the default representation of the domain is that if the value is 1, then the field is true.  the name of the field should be descriptive (e.g. is*condition* true).' ;

