drop table nc_extendedtuple ;

create table nc_extendedtuple(
    uniqueid         bigint    not null,
    tableid          bigint    not null,
    owner            bigint    not null,
    modtime timestamp not null,
    moduser          bigint    not null,
    name             varchar(128)    not null,
    tuplesubclass    varchar(128)    not null,
    tupleclass       varchar(128)    not null,
    constraint nc_extendedtuple_pk primary key (uniqueid) ,
    constraint nc_extendedtuple_sk  unique (uniqueid, tableid) );

-- comment on column nc_extendedtuple.uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_extendedtuple.tableid is 'the table identifier for all data stored within this table.  in conjunction with a unique id creates a unique reference to all tuples within the database for tuple level access control.' ;

-- comment on column nc_extendedtuple.owner is 'the database user who who owns the selected tuple.  this could be the user who created the entry or the user who manages/oversees the user who entered the tuple.' ;

-- comment on column nc_extendedtuple.modtime is 'the modification time of the current entry (year to fraction(5)).' ;

-- comment on column nc_extendedtuple.moduser is 'the user who modified the current tuple entry.  this can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.' ;

-- comment on column nc_extendedtuple.name is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_extendedtuple.tuplesubclass is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_extendedtuple.tupleclass is 'the name column is used to store the name of the object being described by the tuple. ' ;

