drop table nc_rangevalidator ;

create table nc_rangevalidator(
    uniqueid         bigint    not null,
    tableid          bigint    not null,
    owner            bigint    not null,
    modtime timestamp not null,
    moduser          bigint    not null,
    lowlimit         numeric           not null,
    upperlimit       numeric           not null,
    inclowlimit      char(1)           default 'y' not null,
    incupperlimit    char(1)           default 'y' not null,
    constraint check_inc_low_limit check (inclowlimit in ('n','y')),     constraint check_inc_upp_limit check (incupperlimit in ('n','y')), 
    constraint nc_rangevalidator_pk primary key (uniqueid) ,
    constraint nc_rangevalidator_sk  unique (tableid) );

-- comment on column nc_rangevalidator.uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_rangevalidator.tableid is 'the table identifier for all data stored within this table.  in conjunction with a unique id creates a unique reference to all tuples within the database for tuple level access control.' ;

-- comment on column nc_rangevalidator.owner is 'the database user who who owns the selected tuple.  this could be the user who created the entry or the user who manages/oversees the user who entered the tuple.' ;

-- comment on column nc_rangevalidator.modtime is 'the modification time of the current entry (year to fraction(5)).' ;

-- comment on column nc_rangevalidator.moduser is 'the user who modified the current tuple entry.  this can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.' ;

-- comment on column nc_rangevalidator.inclowlimit is 'the istrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  the default representation of the domain is that if the value is 1, then the field is true.  the name of the field should be descriptive (e.g. is*condition* true).' ;

-- comment on column nc_rangevalidator.incupperlimit is 'the istrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  the default representation of the domain is that if the value is 1, then the field is true.  the name of the field should be descriptive (e.g. is*condition* true).' ;

