drop table nc_researchgroup ;

create table nc_researchgroup(
    uniqueid                         bigint    not null,
    tableid                          bigint    not null,
    owner                            bigint    not null,
    modtime timestamp not null,
    moduser                          bigint    not null,
    name                             varchar(128),
    description                      text,
    nc_researchgrouptype_uniqueid    bigint    not null,
    nc_experiment_uniqueid           bigint    not null,
    constraint nc_researchgroup_pk primary key (uniqueid) ,
    constraint nc_researchgroup_sk  unique (uniqueid, tableid) );

-- comment on column nc_researchgroup.uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_researchgroup.tableid is 'the tableid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the uniqueid column these two columns specify a global unique object/tuple identifier within the database.   this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the tableid also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.' ;

-- comment on column nc_researchgroup.owner is 'the database user who who owns the selected tuple.  this could be the user who created the entry or the user who manages/oversees the user who entered the tuple.' ;

-- comment on column nc_researchgroup.modtime is 'the modification time of the current entry (year to fraction(5)).' ;

-- comment on column nc_researchgroup.moduser is 'the user who modified the current tuple entry.  this can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.' ;

-- comment on column nc_researchgroup.name is 'the name of the research group.' ;

-- comment on column nc_researchgroup.description is 'description of research group.' ;

-- comment on column nc_researchgroup.nc_researchgrouptype_uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_researchgroup.nc_experiment_uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

