drop table nc_storedtuple ;

create table nc_storedtuple(
    basetableid        bigint    not null,
    basetupleid        bigint,
    extendedtupleid    bigint    not null,
    uniqueid           bigint    not null,
    tableid            bigint,
    owner              bigint    not null,
    modtime timestamp not null,
    moduser            bigint    not null,
    constraint nc_storedtuple_pk primary key (basetableid, extendedtupleid) ,
    constraint nc_storedtuple_sk  unique (uniqueid) );

-- comment on column nc_storedtuple.basetableid is 'the tableid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the uniqueid column these two columns specify a global unique object/tuple identifier within the database.   this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the tableid also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.' ;

-- comment on column nc_storedtuple.basetupleid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_storedtuple.extendedtupleid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_storedtuple.uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_storedtuple.tableid is 'the table identifier for all data stored within this table.  in conjunction with a unique id creates a unique reference to all tuples within the database for tuple level access control.' ;

-- comment on column nc_storedtuple.owner is 'the database user who who owns the selected tuple.  this could be the user who created the entry or the user who manages/oversees the user who entered the tuple.' ;

-- comment on column nc_storedtuple.modtime is 'the modification time of the current entry (year to fraction(5)).' ;

-- comment on column nc_storedtuple.moduser is 'the user who modified the current tuple entry.  this can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.' ;

