drop table nc_subjexperiment ;

create table nc_subjexperiment(
    uniqueid                     bigint    not null,
    tableid                      bigint    not null,
    owner                        bigint    not null,
    modtime timestamp not null,
    moduser                      bigint    not null,
    nc_experiment_uniqueid       bigint    not null,
    subjectid                    varchar(64)     not null,
    nc_researchgroup_uniqueid    bigint    not null,
    constraint nc_subjexperiment_pk primary key (uniqueid) ,
    constraint nc_subjexperiment_sk  unique (uniqueid, tableid) );

-- comment on column nc_subjexperiment.uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_subjexperiment.tableid is 'the tableid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the uniqueid column these two columns specify a global unique object/tuple identifier within the database.   this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the tableid also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.' ;

-- comment on column nc_subjexperiment.owner is 'the database user who who owns the selected tuple.  this could be the user who created the entry or the user who manages/oversees the user who entered the tuple.' ;

-- comment on column nc_subjexperiment.modtime is 'the modification time of the current entry (year to fraction(5)).' ;

-- comment on column nc_subjexperiment.moduser is 'the user who modified the current tuple entry.  this can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.' ;

-- comment on column nc_subjexperiment.nc_experiment_uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_subjexperiment.subjectid is 'the investigator id for the research subject.' ;

-- comment on column nc_subjexperiment.nc_researchgroup_uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

