drop table nc_visittype ;

create table nc_visittype(
    visittype      varchar(64)     not null,
    uniqueid       bigint    not null,
    tableid        bigint    not null,
    owner          bigint    not null,
    modtime        timestamp(6)     not null,
    moduser        bigint    not null,
    description    text,
    constraint nc_visittype_pk primary key (visittype) ,
    constraint nc_visittype_sk  unique (uniqueid, tableid) );

-- comment on column nc_visittype.visittype is 'the name of the visit type (e.g. ''clinical'' or ''scan'')' ;

-- comment on column nc_visittype.tableid is 'the tableid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the uniqueid column these two columns specify a global unique object/tuple identifier within the database.   this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the tableid also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.' ;

-- comment on column nc_visittype.owner is 'the database user who who owns the selected tuple.  this could be the user who created the entry or the user who manages/oversees the user who entered the tuple.' ;

-- comment on column nc_visittype.modtime is 'the modification time of the current entry (year to fraction(5)).' ;

-- comment on column nc_visittype.moduser is 'the user who modified the current tuple entry.  this can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.' ;

-- comment on column nc_visittype.description is 'description of the visit type' ;

