-- drop some contraints before dropping certain tables

alter table nc_tuplevarchar drop constraint refnc_storedtuple1471;
alter table nc_tupletimestamp drop constraint refnc_storedtuple4301;
alter table nc_tupleinteger drop constraint refnc_storedtuple1451;
alter table nc_tuplefloat drop constraint refnc_storedtuple1461;
alter table nc_tupledata drop constraint refnc_storedtuple661; 
alter table nc_tupleboolean drop constraint refnc_storedtuple1441;

alter table nc_tuplevarchar drop constraint  refnc_tupledata721;
alter table nc_tupletimestamp drop constraint refnc_tupledata4251;
alter table nc_tupleinteger drop constraint refnc_tupledata731;
alter table nc_tuplefloat drop constraint refnc_tupledata741;


\i Tables/nc_analysis_2.sql
\i Tables/nc_analysisComponent_2.sql
\i Tables/nc_analysisFlow_2.sql
\i Tables/nc_analysisResult_2.sql
\i Tables/nc_argumentType_2.sql
\i Tables/nc_conf_database_2.sql
\i Tables/nc_conf_dbuser_2.sql
\i Tables/nc_conf_params_2.sql
\i Tables/nc_conf_params_group_2.sql
\i Tables/nc_conf_privilege_2.sql
\i Tables/nc_conf_webuser_2.sql
\i Tables/nc_conf_webuser_priv_2.sql
\i Tables/nc_executedTransformFlow_2.sql
\i Tables/nc_externalData_2.sql
\i Tables/nc_storedTuple_2.sql
\i Tables/nc_token_2.sql
\i Tables/nc_transformInputData_2.sql
\i Tables/nc_tupleBoolean_2.sql
\i Tables/nc_tupleData_2.sql
\i Tables/nc_tupleFloat_2.sql
\i Tables/nc_tupleInteger_2.sql
\i Tables/nc_tupleTimestamp_2.sql
\i Tables/nc_tupleVarchar_2.sql
\i Tables/nc_executedTransform_2.sql

-- recreate dropped FKs 
alter table nc_tupleboolean add constraint refnc_storedtuple1441 
    foreign key (basetableid, extendedtupleid)
    references nc_storedtuple(basetableid, extendedtupleid)
;
alter table nc_tupledata add constraint refnc_storedtuple661 
    foreign key (basetableid, extendedtupleid)
    references nc_storedtuple(basetableid, extendedtupleid)
;
alter table nc_tuplefloat add constraint refnc_storedtuple1461 
    foreign key (basetableid, extendedtupleid)
    references nc_storedtuple(basetableid, extendedtupleid)
;
alter table nc_tupleinteger add constraint refnc_storedtuple1451 
    foreign key (basetableid, extendedtupleid)
    references nc_storedtuple(basetableid, extendedtupleid)
;
alter table nc_tupletimestamp add constraint refnc_storedtuple4301 
    foreign key (basetableid, extendedtupleid)
    references nc_storedtuple(basetableid, extendedtupleid)
;
alter table nc_tuplevarchar add constraint refnc_storedtuple1471 
    foreign key (basetableid, extendedtupleid)
    references nc_storedtuple(basetableid, extendedtupleid)
;

alter table nc_tuplefloat add constraint refnc_tupledata741 
    foreign key (tableid, uniqueid)
    references nc_tupledata(tableid, uniqueid)
;
alter table nc_tupleinteger add constraint refnc_tupledata731 
    foreign key (tableid, uniqueid)
    references nc_tupledata(tableid, uniqueid)
;
alter table nc_tupletimestamp add constraint refnc_tupledata4251 
    foreign key (tableid, uniqueid)
    references nc_tupledata(tableid, uniqueid)
;
alter table nc_tuplevarchar add constraint refnc_tupledata721 
    foreign key (tableid, uniqueid)
    references nc_tupledata(tableid, uniqueid)
;
-- triggers
-- replace problematic triggers 

\i drop_triggers.sql

select drop_ext_tuple_triggers();
select drop_deriveddata_triggers();
select select drop_rawdata_triggers();

\i extuple_triggers.sql
\i Triggers/nc_deriveddata_ins_upd.sql
\i Triggers/nc_rawdata_ins_upd.sql
 
-- foreign keys

\i FK/DropForeignKeys_2.sql
\i FK/CreateForeignKeys_2.sql


-- update nc_tableid tables


create or replace function create_tableid(varchar) returns integer as '
DECLARE
   table_name_in alias for $1;
   v_MAJORVERSION integer := 1;
   v_MINORVERSION integer := 0;
   v_owner_id integer := -1;
   v_id integer := -1;
   v_tableid integer := -1;
   cur refcursor;
   cr2 CURSOR FOR select distinct owner from nc_tableid;
   cr3 CURSOR FOR select max(tableid)+1 from nc_tableid;
BEGIN
   open cr2;
   fetch cr2 into v_owner_id;
   close cr2;
   open cr3;
   fetch cr3 into v_tableid;
   close cr3;
   open cur FOR EXECUTE ''select uniqueid from nc_tableid where tablename = upper('''' || table_name_in || '''')'';
   fetch cur into v_id;
   if NOT FOUND then 
       raise NOTICE ''Inserting new record'';
       insert into NC_TABLEID (TABLENAME,TABLEID,OWNER,MODTIME,MODUSER,
        MAJORVERSION,MINORVERSION,DESCRIPTION,UNIQUEID) 
       values( upper(table_name_in),
         v_tableid, 
         v_owner_id, now(), v_owner_id, v_MAJORVERSION, v_MINORVERSION, NULL, 
         v_tableid);
   end if;
   close cur; 
 
 return 0;
END;
' LANGUAGE plpgsql;

create or replace function add_admin(varchar,varchar,varchar,varchar) 
returns integer as '
declare
  db_user_name_in ALIAS for $1;
  first_name_in ALIAS for $2;
  last_name_in alias for $3;
  email_in alias for $4;
  owner_id integer;
  person_id integer;
  cur CURSOR FOR select uniqueid from nc_databaseuser where name = ''ADMIN'' and isgroup = false; 
BEGIN
   open cur;
   fetch cur into owner_id;
   if FOUND then
     close cur;
     raise notice ''Already has ADMIN databaseuser record!'';
     return 1;
   end if;
   close cur;

   owner_id := get_database_user_id(db_user_name_in);

   person_id := get_person_id(first_name_in, last_name_in, email_in);
   if person_id < 0 then
      person_id := nextval(''uid_seq''); 
      insert into nc_person (UNIQUEID,TABLEID,OWNER,
        MODTIME,MODUSER,FIRST_NAME, LAST_NAME, EMAIL) 
      values(person_id, get_table_id(''nc_person''), owner_id, 
        now(), owner_id, first_name_in, last_name_in, email_in);
   end if;
   insert into nc_databaseuser (uniqueid,name,tableid,owner,modtime,moduser,
   userclass,userstatus, isgroup, personid) 
     values(nextval(''uid_seq''),''ADMIN'', get_table_id(''nc_databaseuser''),
     owner_id, now(), owner_id, get_userclass_id(''admin''),
            get_userstatus_id(''active''), false, person_id);

  return 0;
END;
' LANGUAGE plpgsql;


select create_tableid('nc_analysis');
select create_tableid('nc_analysisflow');
select create_tableid('nc_analysisresult');

select create_tableid('nc_analysiscomponent');
select create_tableid('nc_argumenttype');
select create_tableid('nc_executedtransformflow');
select create_tableid('nc_externaldata');
select create_tableid('nc_transforminputdata');

-- Fix nc_dataobjecttype records

update nc_dataobjecttype set objecttype = '3_SRB FILE Eprime' where upper(objecttype) = '3_SRB EPRIME FILE';
update nc_dataobjecttype set objecttype = '3_LOC FILE Eprime' where upper(objecttype) = '3_LOC EPRIME FILE';
update nc_dataobjecttype set objecttype = '3_SRB COL A_7.5' where upper(objecttype) = '3_SRB A_7.5 COL';
update nc_dataobjecttype set objecttype = '3_LOC COL A_7.5' where upper(objecttype) = '3_LOC A_7.5 COL';

-- Create an ADMIN databaseuser in not exists

\echo '**************************************************'
\echo 'An ADMIN databaseuser needs to be created for HID web app v2.1'
\echo 'and later. This databaseuser record will be created in'
\echo 'nc_databaseuser table and needs to be associated with '
\echo 'an already existing contact person in nc_person table'
\echo ''

\echo 'Please enter the database username (e.g. postgres)'
\set dbuser '\''  `read v; echo $v` '\''
\echo 'Entered dbuser: ' :dbuser 

\echo 'Please enter the contact person last name for ADMIN user (e.g. Ozyurt)'
\set lastname '\'' `read v; echo $v` '\''
\echo 'Entered lastname: ' :lastname 

\echo 'Please enter the contact person first name for ADMIN user (e.g. Burak)'
\set firstname '\'' `read v; echo $v` '\''
\echo 'Entered lastname: ' :firstname
 
\echo 'Please enter the contact person email address for ADMIN user (e.g. iozyurt@ucsd.edu)'
\set email '\'' `read v; echo $v` '\''
\echo 'Entered email: ' :email 

\echo 'creating admin user'
\echo 'select add_admin(' :dbuser ',' :firstname ',' :lastname ',' :email ');' 
-- select add_admin('postgres','Burak','Ozyurt','iozyurt@ucsd.edu');
select add_admin(:dbuser,:firstname,:lastname,:email);
