create or replace function fix_tableids() returns integer as '
declare
  v_owner_id numeric := -1;
  dbu_cur cursor for select max(a.uniqueid) from nc_databaseuser a, 
   nc_userclass b where a.userclass = b.uniqueid and 
   b.userclass=''admin'' and a.isgroup = false; 
begin
  open dbu_cur;
  fetch dbu_cur into v_owner_id;
  close dbu_cur;
  if v_owner_id is NULL then
     raise notice ''No admin class user in nc_databaseuser table! Exiting!'';
     return -1;
  end if;
  insert into nc_tableid (tablename,tableid,owner,modtime,moduser,
        majorversion,minorversion,description,uniqueid)
   select upper(tablename), nextval(''uid_seq''), v_owner_id, now(), 
        v_owner_id, 1, 0, null, -1 from pg_tables 
    where (tablename like ''nc__%'' or tablename like ''bk__%'') and 
    upper(tablename) not in (select tablename from nc_tableid);

    update nc_tableid set uniqueid = tableid;
  return 0;
end;
' LANGUAGE plpgsql;
