
create or replace function has_securityclassification(varchar) returns boolean as '
declare
  sec_class_in ALIAS for $1;
  sc_cur cursor for select uniqueid from nc_securityclassification where
    securityclassification = sec_class_in; 
  uniqueid numeric := -1;
begin
  open sc_cur;
  fetch sc_cur into uniqueid;
  if uniqueid is NULL then
     close sc_cur;
     return false;
   end if;
   close sc_cur;
   return true;
END;
' LANGUAGE plpgsql;

create or replace function has_ontologyconcept(varchar) returns boolean as '
declare
  conceptid_in ALIAS for $1;
  oc_cur cursor for select uniqueid from nc_ontologyconcept where conceptid = conceptid_in;
  uniqueid numeric := -1;
begin
  open oc_cur;
  fetch oc_cur into uniqueid;
  if uniqueid is NULL then
     close oc_cur;
     return false;
   end if;
   close oc_cur;
   return true;
END;
' LANGUAGE plpgsql;

create or replace function has_ontologysource(varchar) returns boolean as '
declare
  ontologysource_in ALIAS for $1;
  os_cur cursor for select uniqueid from nc_ontologysource where ontologysource = ontologysource_in;
  uniqueid numeric := -1;
begin
  open os_cur;
  fetch os_cur into uniqueid;
  if uniqueid is NULL then
     close os_cur;
     return false;
   end if;
   close os_cur;
   return true;
END;
' LANGUAGE plpgsql;

create or replace function has_site(varchar) returns boolean as '
declare
  sitename_in ALIAS for $1;
  site_cur cursor for select uniqueid from nc_site where sitename = sitename_in;
  uniqueid numeric := -1;
begin
  open site_cur;
  fetch site_cur into uniqueid;
  if uniqueid is NULL then
     close site_cur;
     return false;
   end if;
   close site_cur;
   return true;
END;
' LANGUAGE plpgsql;

create or replace function has_dot(varchar,varchar) returns boolean as '
declare
  objecttype_in ALIAS for $1;
  actions_in ALIAS for $2;
  dot_cur cursor for select uniqueid from nc_dataobjecttype where 
    objecttype = objecttype_in and applicableactions = actions_in;
  uniqueid numeric := -1;
begin
  open dot_cur;
  fetch dot_cur into uniqueid;
  if uniqueid is NULL then
     close dot_cur;
     return false;
   end if;
   close dot_cur;
   return true;
END;
' LANGUAGE plpgsql;


create or replace function has_protocol(varchar) returns boolean as '
declare 
  protocolid_in ALIAS for $1;
  pr_cur cursor for select uniqueid from nc_protocol where protocolid = protocolid_in;
  uniqueid numeric := -1;
begin
  open pr_cur;
  fetch pr_cur into uniqueid;
  if uniqueid is NULL then
     close pr_cur;
     return false;
   end if;
   close pr_cur;
   return true;
END;
' LANGUAGE plpgsql;

create or replace function  has_collectioneq(varchar, varchar)
  returns boolean as '
declare
  make_in ALIAS for $1;
  model_in ALIAS for $2;
  ce_cur cursor for select uniqueid from nc_collectionequipment where make = make_in and model = model_in;
  uniqueid numeric := -1;
begin
  open ce_cur;
  fetch ce_cur into uniqueid;
  if uniqueid is NULL then
     close ce_cur;
     return false;
   end if;
   close ce_cur;
   return true;
END;
' LANGUAGE plpgsql;

--
-- Example usage
-- select  prepare_static_data_project('postgres', 'UCSD');
create or replace function prepare_static_data_project(varchar, varchar) 
  returns integer as '
declare
  database_user_name_in ALIAS for $1;
  site_name_in ALIAS for $2;
  v_owner_id integer;
BEGIN
    v_owner_id := get_database_user_id(database_user_name_in);

-- nc_collectionequipment
if not has_collectioneq(''Psychology Software Tools'',''Eprime 1.1 (1.1.4.1)'') then
insert into nc_collectionequipment(UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, MAKE,MODEL)
values(nextval(''uid_seq''), get_table_id(''nc_collectionequipment''), v_owner_id, now(), v_owner_id, ''Psychology Software Tools'',''Eprime 1.1 (1.1.4.1)'');
end if;
if not has_collectioneq(''Marconi Medical Systems, Inc'',''Eclipse 1.5T'') then
insert into nc_collectionequipment(UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, MAKE,MODEL)
values(nextval(''uid_seq''), get_table_id(''nc_collectionequipment''), v_owner_id, now(), v_owner_id, ''Marconi Medical Systems, Inc'',''Eclipse 1.5T'');
end if;

--nc_securityclassification
if not has_securityclassification(''FIRST BIRN'') then
insert into nc_securityclassification(UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, SECURITYCLASSIFICATION, DESCRIPTION)
values(nextval(''uid_seq''), get_table_id(''nc_securityclassification''), v_owner_id, now(), v_owner_id, ''FIRST BIRN'',''shared by BIRN with many identifiers being removed'');
end if;

--nc_ontologySource
if not has_ontologysource(''UMLS'') then
insert into nc_ontologySource(ONTOLOGYSOURCE, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, 
      SOURCEURI, DESCRIPTION)
   values(''UMLS'', get_table_id(''nc_ontologySource''), nextval(''uid_seq''), v_owner_id, now(), v_owner_id,
      null, '' '');
end if;

--nc_ontologyConcept
if not has_ontologyconcept(''9999'') then
insert into nc_ontologyConcept(ONTOLOGYSOURCE,CONCEPTID,CONCEPT,TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, ONTOLOGYPATH)
values(''UMLS'', ''9999'', ''just a placeholder'', get_table_id(''nc_ontologyConcept''), nextval(''uid_seq''), 
         v_owner_id, now(), v_owner_id, null);
end if;
--nc_protocol
-- if not has_protocol(''pre-scan protocol'') then
-- insert into nc_protocol(protocolversion, protocolID, UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, name, DESCRIPTION)
-- values(1, ''pre-scan protocol'', nextval(''uid_seq''), get_table_id(''nc_protocol''), v_owner_id, now(), v_owner_id, 
--           ''pre-scan protocol'', ''Quick mood scale is used before fMRI scanning'');
-- end if;

-- if not has_protocol(''post-scan protocol'') then
-- insert into nc_protocol(protocolversion, protocolID, UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, name, DESCRIPTION)
-- values(1, ''post-scan protocol'', nextval(''uid_seq''), get_table_id(''nc_protocol''), v_owner_id, now(), v_owner_id, 
--           ''post-scan protocol'', ''Quick mood scale is used after fMRI scanning'');
-- end if;

-- if not has_protocol(''human phantom screening protocol'') then
-- insert into nc_protocol(protocolversion, protocolID, UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, name, DESCRIPTION)
-- values(1, ''human phantom screening protocol'', nextval(''uid_seq''), get_table_id(''nc_protocol''), v_owner_id, now(), v_owner_id, 
--           ''human phantom screening protocol'', ''following screening assessments are used: (1) Beck Depression Inventory (BDI); (2) Anxiety Status Inventory (ASI); (3) North American Adult Reading Test (NAART); (4) Self-rating Anxiety Scale (SAS); (5) SCID non-patient (overview and screening module) modified by Stanford University, 9/27/1999.'');

-- end if;
-- if not has_protocol(''audio setup phase 1 of 3'') then
-- insert into nc_protocol(protocolversion, protocolID, UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, name, DESCRIPTION)
-- values(1, ''audio setup phase 1 of 3'', nextval(''uid_seq''), get_table_id(''nc_protocol''), v_owner_id, now(), v_owner_id, 
--           ''audio setup phase 1 of 3'', ''to adjust headphone placement and tunes. Position subject on the scan sitting up, with Avotec headphones on. No earplugs are used in conjunction with the Avotec headphones. The subject is presented a tone in the left ear and is given visual instruction to press a button using the button box if they can hear it as such (e.g., press a button if you can hear tone in your left ear). The button press triggers the tone to terminate in the left ear and start in the right. Likewise, the subject is prompted to hit a button to confirm that they can hear tone in their right ear. This button press triggers the tone to be played in both ears at equal volumes. The subject hits a button again if they can hear tones in both ears. This triggers the termination of phase 1. Subjects may also sign to the experimenter using hand cues, verbal response, etc. The experimenter can advance the exeriment by pressing the respective buttons on the E-Prime computer keyboard.'');
-- end if;

-- if not has_protocol(''audio setup phase 2 of 3'') then
-- insert into nc_protocol(protocolversion, protocolID, UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, name, DESCRIPTION)
-- values(1, ''audio setup phase 2 of 3'', nextval(''uid_seq''), get_table_id(''nc_protocol''), v_owner_id, now(), v_owner_id, 
 --          ''audio setup phase 2 of 3'', ''to adjust balance of headphone. Position subject on the scan table supine, with Avotec headphones on and bite bar in place in head coil. Place the button response box in the subject''''s dominant hand and the scanner''''s squeeze ball or other non-verbal patient alert system in the other hand, as only non-verbal communication will be used during the scans due to the bite bar and good general fMRI practice. During functional scans a "dummy button box" will be also used in this hand, and the squeeze ball can be set aside for emergency communication with the operator (e.g. to stop the scan). The dummy button box should be designed to mimic the size and shape of the actual button box. Advance the subject inside the magnet bore. Confirm that the subject is comfortable (e.g., not claustrophobic) and can communicate with you in the control room (e.g., If you can hear me and you are comfortable please squeeze the squeeze ball.). If you don''''t get a response, that is not alright, because IRBs don''''t like reports of unresponsive (dead) subjects. subjects hear a tone that is 5dB (-500) louder in the left ear than in the right. Subjects are instructed to make the tone sound balanced using the button box. Button "1" moves the tone to the left ear and button "2" moves the tone to the right ear. Each button press triggers a 1dB step change in the direction specified by the button press. When the tone sounds balanced, subjects press "3." This terminates phase 2, and records the observed balance in the subject''''s .edat file. This data is obtained only after each of the three task phases is complete.'');
-- end if;

-- if not has_protocol(''audio setup phase 3 of 3'') then
-- insert into nc_protocol(protocolversion, protocolID, UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, name, DESCRIPTION)
-- values(1, ''audio setup phase 3 of 3'', nextval(''uid_seq''), get_table_id(''nc_protocol''), v_owner_id, now(), v_owner_id, 
--           ''audio setup phase 3 of 3'', ''begins with a slide of an infinite duration that reads "Preparing to begin phase 3. Please wait." Before proceeding to the next slide in phase 3, the experimenter manually starts a functional scan. This is done to supply scanner background noise; no scan data are saved. After the scanner is started, the experimenter presses any key on the E-Prime computer to proceed. A 440Hz tone is presented 32 times at random volumes, ranging from -3000 to -9000. The subject is instructed to press a button on the keypad every time they hear a tone. Phase 3 terminates after all 31 tone volumes are presented, after which the functional scan is terminated manually. Chooses option 4 from the audio setup task menu to exit the task. While the subject is still in the scanner, open the scan subject''''s data file using E-Data Aid. Balance_ver#.anl is used to obtain recorded auditory balance. SensationLevel_ver#.anl is used to obtain the minimum (smallest) volume level. 6000 is added to the minimum volume level to obtain a new volume level. If the resulting number is above 0, the experimenter should turn up the overall volume and run phase 3 again. The new volume level is used to set the volume levels of the MMN and sensory-motor tasks.'');
-- end if;

-- if not has_protocol(''reaction time test'') then
-- insert into nc_protocol(protocolversion, protocolID, UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, name, DESCRIPTION)
-- values(1, ''reaction time test'', nextval(''uid_seq''), get_table_id(''nc_protocol''), v_owner_id, now(), v_owner_id, 
--           ''reaction time test'', ''to measure the effects of keypad ergonomics on subjects'''' RTs. Since motor tasks are believed to demonstrate good reproducibility, differences in a subject''''s RT between scan sites will be attributed to differences in keypad ergonomics. Subjects are shown a series of random numbers that range from 1 to 4. Subjects press keypad buttons that correspond to the visual cue, i.e. the subject will press "3" on the scanner button box when the number "3" appears on the screen. 32 total stimuli appear at 2s intervals. The stimulus remains on the screen until a response is given or 2s if no button is pressed. Subjects are instructed to respond as quickly and as accurately as possible. RT is measured in milliseconds. No scan data are recorded. Accuracy and reaction times are obtained at the end of entire scan protocol is complete.'');
-- end if;

-- if not has_protocol(''anatomic scan: sagital localizer scan'') then
-- insert into nc_protocol(protocolversion, protocolID, UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, name, DESCRIPTION)
-- values(1, ''anatomic scan: sagital localizer scan'', nextval(''uid_seq''), get_table_id(''nc_protocol''), v_owner_id, now(), v_owner_id, 
--           ''anatomic scan: sagital localizer scan'', ''Pulse sequence = GRE or 3-plane localizer GRE, Scan plane = sagittal or all, FOV = 22 cm, 3 slices, 5mm interleaved (no skip) 256x128 matrix'');
-- end if;

-- if not has_protocol(''anatomic scan: T2 inplane scan'') then
-- insert into nc_protocol(protocolversion, protocolID, UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, name, DESCRIPTION)
-- values(1, ''anatomic scan: T2 inplane scan'', nextval(''uid_seq''), get_table_id(''nc_protocol''), v_owner_id, now(), v_owner_id, 
--           ''anatomic scan: T2 inplane scan'', ''Pulse sequence = FSE/TSE (or equivalent RARE), Scan plane = oblique axial, AC-PC. This is the same as the functional prescription, FOV = 22 cm, 35 slices, 4mm interleaved (no skip), TR/TE = 4000ms /68 ms (or so), Echo Train Length (or turbo factor, or equivalent nomenclature) = 12, 256x192 matrix'');
-- end if;

-- if not has_protocol(''anatomic scan: 3D FSPGR or T1 scan'') then
-- insert into nc_protocol(protocolversion, protocolID, UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, name, DESCRIPTION)
-- values(1, ''anatomic scan: 3D FSPGR or T1 scan'', nextval(''uid_seq''), get_table_id(''nc_protocol''), v_owner_id, now(), v_owner_id, 
--           ''anatomic scan: 3D FSPGR or T1 scan'', ''Pulse sequence = IR-Prep Fast/Turbo Spoiled Grass or equivalent, Scan plane = axial, FOV = 22x16.5 cm (0.75 FOV in R/L direction), 124-128 slices, 1.2mm, TR/TE/FA = 9.8ms/(minimum)/15 deg, TI = 300 ms, 256x192 matrix, BW = 115.625 kHz, NEX = 2'');
-- end if;

-- if not has_protocol(''cognitive task scan: MMN'') then
-- insert into nc_protocol(protocolversion, protocolID, UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, name, DESCRIPTION)
-- values(1, ''cognitive task scan: MMN'', nextval(''uid_seq''), get_table_id(''nc_protocol''), v_owner_id, now(), v_owner_id, 
--           ''cognitive Task: MMN (mismatch negativity)'', ''Scan: Pulse sequence = EPI or Spiral GRE, Scan plane = oblique axial, AC-PC, copy T2 in-plane prescription, FOV = 22 cm, 35 slices, contiguous 4mm, TR = 3000ms, TE = 30ms (3T/4T), 40ms (1.5T), FA = 90 degrees, BW = 1100 kHz, 64x64 matrix, 1 shot, 2 dummy frames. Task: Total task time = 8:06 (includes 6 sec for DDAs), Time frames = 162 (includes 2 DDAs w/TR = 3s), The task contains 2 1000 Hz control blocks, 2 1200 Hz control blocks, 4 mismatch blocks, 7 30sec rest blocks and 2 15sec rest blocks. During every block, subjects see a red and green checkerboard that reverses color contrast every 430 to 1500ms. Subjects are instructed to pay attention to the checkerboard and press "1" when the orientation changes. During the control and mismatch blocks, subjects also hear 100ms tones at 300ms intervals. This script will require the balance and volume levels obtained in audio setup task to be typed in at the start of the task.'');
-- end if;

-- if not has_protocol(''cognitive task scan: SIRP'') then
-- insert into nc_protocol(protocolversion, protocolID, UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, name, DESCRIPTION)
-- values(1, ''cognitive task scan: SIRP'', nextval(''uid_seq''), get_table_id(''nc_protocol''), v_owner_id, now(), v_owner_id, 
--           ''cognitive task scan: SIRP (Sternberg Item Recognition Paradigm)'', ''Scan: Pulse sequence = EPI or Spiral GRE, Scan plane = oblique axial, AC-PC, copy T2 in-plane prescription, FOV = 22 cm, 35 slices, contiguous 4mm, TR = 3000ms, TE = 30ms (3T/4T), 40ms (1.5T), FA = 90 degrees, BW = 1100 kHz, 64x64 matrix, 1 shot, 2 dummy frames. Task: Total task time: 7:27 (includes 6 sec for DDAs), Time Frames: 149 (includes 2 DDAs w/TR = 3s); Prior to the start of this task, subjects reposition the button box. The left thumb is placed on button 1, and the right thumb on button 4. The task consists of four conditions. In three conditions, subjects are shown a series of 1, 3 or 5 target numbers in red, followed by a series of test numbers in green. Subjects are asked to learn the sets of red numbers and are instructed to press "1" if the green test number matches one of the targets and "4" if it does not. During the other condition, subjects are shown a series of arrows that point to the left or right directions. Subjects press "1" if the arrows point in the left direction and "4" if they point to the right. The order of the four conditions will vary. Subjects fixate on a flashing cross between conditions.'');
-- end if;

-- if not has_protocol(''sensory motor task scan'') then
-- insert into nc_protocol(protocolversion, protocolID, UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, name, DESCRIPTION)
-- values(1, ''sensory motor task scan'', nextval(''uid_seq''), get_table_id(''nc_protocol''), v_owner_id, now(), v_owner_id, 
--           ''sensory motor task scan'', ''Scan: Pulse sequence = EPI or Spiral GRE, Scan plane = oblique axial, AC-PC, copy T2 in-plane prescription, FOV = 22 cm, 35 slices, contiguous 4mm, TR = 3000ms, TE = 30ms (3T/4T), 40ms (1.5T), FA = 90 degrees, BW = 1100 kHz, 64x64 matrix, 1 shot, 2 dummy frames. TasK: Total task time: 4:06 (includes 6 sec for DDAs), Time frames: 82 (includes 2 DDAs w/TR = 3s). Subjects perform bilateral finger tapping on button boxes (1 dummy button box and 1 actual) in time with 3Hz audio cue and flashing checkerboard square. Subjects press buttons 1 through 4 in consecutive order and then back again using both hands at simultaneously and in sync. Assuming index finger = 1, middle finger = 2, ring finger = 3, little finger = 4, finger tapping is as follows: 1234432112344321, etc. This script will require the balance and volume levels obtained in step 1 to be typed in at the start of the task.'');
-- end if;

-- if not has_protocol(''resting state scan'') then
-- insert into nc_protocol(protocolversion, protocolID, UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, name, DESCRIPTION)
-- values(1, ''resting state scan'', nextval(''uid_seq''), get_table_id(''nc_protocol''), v_owner_id, now(), v_owner_id, 
--           ''resting state scan'', ''Scan: Pulse sequence = EPI or Spiral GRE, Scan plane = oblique axial, AC-PC, copy T2 in-plane prescription, FOV = 22 cm, 35 slices, contiguous 4mm, TR = 3000ms, TE = 30ms (3T/4T), 40ms (1.5T), FA = 90 degrees, BW = 1100 kHz, 64x64 matrix, 1 shot, 2 dummy frames. TasK: Total task time: 4:06 (includes 6 sec for DDAs), Time frames: 82 (includes 2 DDAs w/TR = 3s), This task is used to measure subject''''s baseline activity. Subjects are instructed to relax and fixate on a cross.'');
-- end if;

-- if not has_protocol(''breath-holding task scan'') then
-- insert into nc_protocol(protocolversion, protocolID, UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, name, DESCRIPTION)
-- values(1, ''breath-holding task scan'', nextval(''uid_seq''), get_table_id(''nc_protocol''), v_owner_id, now(), v_owner_id, 
--           ''breath-holding task scan'', ''Scan: Pulse sequence = EPI or Spiral GRE, Scan plane = oblique axial, AC-PC, copy T2 in-plane prescription, FOV = 22 cm, 35 slices, contiguous 4mm, TR = 3000ms, TE = 30ms (3T/4T), 40ms (1.5T), FA = 90 degrees, BW = 1100 kHz, 64x64 matrix, 1 shot, 2 dummy frames. Task: Total task time: 4:06 (includes 6 sec for DDAs), Time frames: 82 (includes 2 DDAs w/TR = 3s). This task is used to measure subjects'''' global vascular reactivity and consists of a block design with alternating on/off blocks of 15-second periods of breath holding and normal breathing. During the on-block, the subject is shown a picture of a circle that becomes smaller as time progresses. This indicates the general amount of time left before breathing can resume. During the off-block, the subject breathes normally and fixates on a cross. They are prompted before the breath-hold block to get ready.'' );
-- end if;          


---
if not has_dot(''1_SRB COL'', ''DOWNLOAD'') then
 insert into nc_dataobjecttype(uniqueid, tableid, owner, modtime, moduser, objecttype, 
      applicableactions, description) 
     values(nextval(''uid_seq''),  get_table_id(''nc_dataobjecttype''), 
      v_owner_id, now(), v_owner_id, 
      ''1_SRB COL'', ''DOWNLOAD'', 
      ''SRB collection specified by nc_researchdata.dataURI'');
end if;

if not has_dot(''1_SRB CHILD COL'', ''DOWNLOAD'') then
    insert into nc_dataobjecttype(uniqueid, tableid, owner, modtime, moduser, 
     objecttype, applicableactions, description) 
     values(nextval(''uid_seq''), get_table_id(''nc_dataobjecttype''),
      v_owner_id, now(), v_owner_id, 
     ''1_SRB CHILD COL'', ''DOWNLOAD'', 
     ''SRB child collection under the collection specified by nc_researchdata.dataURI'');
end if;

if not has_dot(''1_SRB FILE'', ''DOWNLOAD'') then
    insert into nc_dataobjecttype(uniqueid, tableid, owner, modtime, moduser, 
      objecttype, applicableactions, description) 
     values(nextval(''uid_seq''),  get_table_id(''nc_dataobjecttype''),
       v_owner_id, now(), v_owner_id, 
       ''1_SRB FILE'', ''DOWNLOAD'', 
       ''SRB File specified by nc_researchdata.dataURI'');
end if;

if not has_dot(''1_SRB CHILD F'', ''DOWNLOAD'') then
     insert into nc_dataobjecttype(uniqueid, tableid, owner, modtime, moduser, 
       objecttype, applicableactions, description) 
     values(nextval(''uid_seq''), get_table_id(''nc_dataobjecttype''),
          v_owner_id, now(), v_owner_id, 
         ''1_SRB CHILD F'', ''DOWNLOAD'', 
          ''SRB child file under the collection specified by nc_researchdata.dataURI'');
end if;


if not has_dot(''2_HTML'', ''DOWNLOAD'') then
    insert into nc_dataobjecttype(uniqueid, tableid, owner, modtime, moduser, 
      objecttype, applicableactions, description) 
    values( nextval(''uid_seq''), get_table_id(''nc_dataobjecttype''),
     v_owner_id, now(), v_owner_id, 
     ''2_HTML'', ''DOWNLOAD'', 
     ''HTML file specified by both nc_researchdata.dataURI and objectname'');
end if;

if not has_dot(''2_DICOM'', ''DOWNLOAD'') then
     insert into nc_dataobjecttype(uniqueid, tableid, owner, modtime, moduser, 
       objecttype, applicableactions, description) 
     values( nextval(''uid_seq''), get_table_id(''nc_dataobjecttype''),
       v_owner_id, now(), v_owner_id, 
       ''2_DICOM'', ''DOWNLOAD'', 
      ''DICOM image file specified by both nc_researchdata.dataURI and objectname'');
end if;

if not has_dot(''2_NIFTI'', ''DOWNLOAD'') then
      insert into nc_dataobjecttype(uniqueid, tableid, owner, modtime, moduser, 
         objecttype, applicableactions, description) 
      values(nextval(''uid_seq''), get_table_id(''nc_dataobjecttype''),
          v_owner_id, now(), v_owner_id, 
         ''2_NIFTI'', ''DOWNLOAD'', 
         ''NIFTI image file specified by both nc_researchdata.dataURI and objectname'');
end if;

if not has_dot(''3_GFTP COL A_7.5'', ''DOWNLOAD'') then
      insert into nc_dataobjecttype(uniqueid, tableid, owner, modtime, moduser, 
         objecttype, applicableactions, description) 
       values(nextval(''uid_seq''), get_table_id(''nc_dataobjecttype''),
          v_owner_id, now(), v_owner_id, 
        ''3_GFTP COL A_7.5'', ''DOWNLOAD'', 
        ''A directory that contains ANALYZE_7.5 image data.'');
end if;

if not has_dot(''3_LOC COL A_7.5'', ''DOWNLOAD'') then
      insert into nc_dataobjecttype(uniqueid, tableid, owner, modtime, moduser, 
         objecttype, applicableactions, description) 
       values(nextval(''uid_seq''), get_table_id(''nc_dataobjecttype''),
          v_owner_id, now(), v_owner_id, 
        ''3_LOC COL A_7.5'', ''DOWNLOAD'', 
        ''A directory that contains ANALYZE_7.5 image data.'');
end if;
        
if not has_dot(''3_GFTP FILE Eprime'', ''DOWNLOAD'') then
      insert into nc_dataobjecttype(uniqueid, tableid, owner, modtime, moduser, 
         objecttype, applicableactions, description) 
       values(nextval(''uid_seq''), get_table_id(''nc_dataobjecttype''),
        v_owner_id, now(), v_owner_id, 
        ''3_GFTP FILE Eprime'', ''DOWNLOAD'', 
        ''Eprime file contains fMRI task data.'');
end if;

if not has_dot(''3_LOC FILE Eprime'', ''DOWNLOAD'') then
      insert into nc_dataobjecttype(uniqueid, tableid, owner, modtime, moduser, 
         objecttype, applicableactions, description) 
       values(nextval(''uid_seq''), get_table_id(''nc_dataobjecttype''),
        v_owner_id, now(), v_owner_id, 
        ''3_LOC FILE Eprime'', ''DOWNLOAD'', 
        ''Eprime file contains fMRI task data.'');
end if;


if not has_dot(''3_LOC COL NIFTI'', ''DOWNLOAD'') then
      insert into nc_dataobjecttype(uniqueid, tableid, owner, modtime, moduser, 
         objecttype, applicableactions, description) 
       values(nextval(''uid_seq''), get_table_id(''nc_dataobjecttype''),
        v_owner_id, now(), v_owner_id, 
        ''3_LOC COL NIFTI'', ''DOWNLOAD'', 
        ''Image collection in NIFTI format.'');
end if;

if not has_dot(''3_GFTP COL NIFTI'', ''DOWNLOAD'') then
      insert into nc_dataobjecttype(uniqueid, tableid, owner, modtime, moduser, 
         objecttype, applicableactions, description) 
       values(nextval(''uid_seq''), get_table_id(''nc_dataobjecttype''),
        v_owner_id, now(), v_owner_id, 
        ''3_GFTP COL NIFTI'', ''DOWNLOAD'', 
        ''Image collection in NIFTI format.'');
end if;

if not has_dot(''3_LOC FILE DICOM'', ''DOWNLOAD'') then
      insert into nc_dataobjecttype(uniqueid, tableid, owner, modtime, moduser, 
         objecttype, applicableactions, description) 
       values(nextval(''uid_seq''), get_table_id(''nc_dataobjecttype''),
        v_owner_id, now(), v_owner_id, 
        ''3_LOC FILE DICOM'', ''DOWNLOAD'', 
        ''Image file in DICOM format.'');
end if;

if not has_dot(''3_GFTP FILE DICOM'', ''DOWNLOAD'') then
      insert into nc_dataobjecttype(uniqueid, tableid, owner, modtime, moduser, 
         objecttype, applicableactions, description) 
       values(nextval(''uid_seq''), get_table_id(''nc_dataobjecttype''),
        v_owner_id, now(), v_owner_id, 
        ''3_GFTP FILE DICOM'', ''DOWNLOAD'', 
        ''Image file in DICOM format.'');
end if;

if not has_dot(''3_LOC FILE DICOM'', ''DOWNLOAD'') then
      insert into nc_dataobjecttype(uniqueid, tableid, owner, modtime, moduser, 
         objecttype, applicableactions, description) 
       values(nextval(''uid_seq''), get_table_id(''nc_dataobjecttype''),
        v_owner_id, now(), v_owner_id, 
        ''3_LOC FILE DICOM'', ''DOWNLOAD'', 
        ''Image file in DICOM format.'');
end if;

if not has_dot(''3_LOC COL DICOM'', ''DOWNLOAD'') then
      insert into nc_dataobjecttype(uniqueid, tableid, owner, modtime, moduser, 
         objecttype, applicableactions, description) 
       values(nextval(''uid_seq''), get_table_id(''nc_dataobjecttype''),
        v_owner_id, now(), v_owner_id, 
        ''3_LOC COL DICOM'', ''DOWNLOAD'', 
        ''Image series in DICOM format.'');
end if;

if not has_dot(''3_LOC FILE PFILE'', ''DOWNLOAD'') then
      insert into nc_dataobjecttype(uniqueid, tableid, owner, modtime, moduser, 
         objecttype, applicableactions, description) 
       values(nextval(''uid_seq''), get_table_id(''nc_dataobjecttype''),
        v_owner_id, now(), v_owner_id, 
        ''3_LOC FILE PFILE'', ''DOWNLOAD'', 
        ''GE P-File.'');
end if;

if not has_dot(''3_LOC FILE AFNI'', ''DOWNLOAD'') then
      insert into nc_dataobjecttype(uniqueid, tableid, owner, modtime, moduser, 
         objecttype, applicableactions, description) 
       values(nextval(''uid_seq''), get_table_id(''nc_dataobjecttype''),
        v_owner_id, now(), v_owner_id, 
        ''3_LOC FILE AFNI'', ''DOWNLOAD'', 
        ''AFNI Brik File.'');
end if;

-- for nc_site table
if not has_site(''Duke'') then
insert into nc_site
select nextval(''uid_seq''), get_table_id(''nc_site''), v_owner_id, now(),v_owner_id , ''0003'', ''Duke'', 0, ''databaseAddress'', ''hidprd'',
''Postgres'', ''10.2.0.2.0'', 5432, ''contactFirstName'', ''contactLastName'',  ''contactEmail'', ''contactPhone''
from nc_tableID where tablename = ''NC_SITE'';
end if;

if not has_site(''BWH'') then
insert into nc_site
select nextval(''uid_seq''), get_table_id(''nc_site''), v_owner_id, now(),v_owner_id , ''0005'', ''BWH'', 0, ''databaseAddress'', ''hidprd'',
''Postgres'', ''10.2.0.2.0'', 5432, ''contactFirstName'', ''contactLastName'',  ''contactEmail'', ''contactPhone''
from nc_tableID where tablename = ''NC_SITE'';
end if;

if not has_site(''MGH'') then
insert into nc_site
select nextval(''uid_seq''), get_table_id(''nc_site''), v_owner_id, now(),v_owner_id , ''0006'', ''MGH'', 0, ''databaseAddress'', ''hidprd'',
''Postgres'', ''10.2.0.2.0'', 5432, ''contactFirstName'', ''contactLastName'',  ''contactEmail'', ''contactPhone''
from nc_tableID where tablename = ''NC_SITE'';
end if;

if not has_site(''UCLA'') then
insert into nc_site
select nextval(''uid_seq''), get_table_id(''nc_site''), v_owner_id, now(),v_owner_id , ''0007'', ''UCLA'', 0, ''databaseAddress'', ''fbirn_test'',
''Postgres'', ''?'', 5432, ''contactFirstName'', ''contactLastName'',  ''contactEmail'', ''contactPhone''
from nc_tableID where tablename = ''NC_SITE'';
end if;

if not has_site(''UCSD'') then
insert into nc_site
select nextval(''uid_seq''), get_table_id(''nc_site''), v_owner_id, now(),v_owner_id ,''0008'', ''UCSD'', 0, ''databaseAddress'', ''hidprd'',
''Postgres'', ''10.2.0.2.0'', 5432, ''contactFirstName'', ''contactLastName'',  ''contactEmail'', ''contactPhone''
from nc_tableID where tablename = ''NC_SITE'';
end if;

if not has_site(''UCI'') then
insert into nc_site
select nextval(''uid_seq''), get_table_id(''nc_site''), v_owner_id, now(),v_owner_id ,''0009'', ''UCI'', 0, ''databaseAddress'', ''hidprd'',
''Postgres'', ''10.2.0.2.0'', 5432, ''contactFirstName'', ''contactLastName'',  ''contactEmail'', ''contactPhone''
from nc_tableID where tablename = ''NC_SITE'';
end if;

if not has_site(''UNM'') then
insert into nc_site
select nextval(''uid_seq''), get_table_id(''nc_site''), v_owner_id, now(),v_owner_id , ''0010'', ''UNM'', 0, ''databaseAddress'', ''hidprd'',
''Postgres'', ''10.2.0.2.0'', 5432, ''contactFirstName'', ''contactLastName'',  ''contactEmail'', ''contactPhone''
from nc_tableID where tablename = ''NC_SITE'';
end if;

if not has_site(''Iowa'') then
insert into nc_site
select nextval(''uid_seq''), get_table_id(''nc_site''), v_owner_id, now(),v_owner_id , ''0012'', ''Iowa'', 0, ''databaseAddress'', ''hidprd'',
''Postgres'', ''10.2.0.2.0'', 5432, ''contactFirstName'', ''contactLastName'',  ''contactEmail'', ''contactPhone''
from nc_tableID where tablename = ''NC_SITE'';
end if;

if not has_site(''UMN'') then
insert into nc_site
select nextval(''uid_seq''), get_table_id(''nc_site''), v_owner_id, now(),v_owner_id , ''0013'', ''UMN'', 0, ''databaseAddress'', ''hidprd'',
''Postgres'', ''10.2.0.2.0'', 5432, ''contactFirstName'', ''contactLastName'',  ''contactEmail'', ''contactPhone''
from nc_tableID where tablename = ''NC_SITE'';
end if;


if not has_site(''Yale'') then
insert into nc_site
  select nextval(''uid_seq''), get_table_id(''nc_site''), v_owner_id, now(),v_owner_id , ''0018'', ''Yale'', 0, ''databaseAddress'', ''hidprd'',
''Postgres'', ''10.2.0.2.0'', 5432, ''contactFirstName'', ''contactLastName'',  ''contactEmail'', ''contactPhone''
from nc_tableID where tablename = ''NC_SITE'';
end if;

  update nc_site set isPrimary = 1 where sitename = site_name_in;         
  return 0;
END;
' LANGUAGE plpgsql;

