#!/bin/sh

if [ "$#" != 3 ]
then
  echo "usage: $0 <host> <port> <cmd>"
  exit 1
fi
HOSTNAME=$1
PORT=$2
 
if [ "$CLINICAL_HOME" == "" ]
then
  CLINICAL_HOME=$HOME/dev/java/BIRN/clinical
fi
if [ ! -d "$CLINICAL_HOME" ]
then 
  echo ""
  echo "Cannot continue"
  echo "Please set the environment var CLINICAL_HOME to a valid directory:$CLINICAL_HOME"
  exit 1;
fi

unset CLASSPATH

for lib in $CLINICAL_HOME/lib/*.jar
do
  if [ "$CLASSPATH" == "" ]
  then
    CLASSPATH=$lib
  else
    CLASSPATH=${CLASSPATH}:$lib
  fi
done

PARAMS="-Djavax.net.debug=all -Djava.protocol.handler.pkgs=com.sun.net.internal.www.protocol -Djavax.net.ssl.trustStore=\"/home/bozyurt/clinical_client.ks\" -Djavax.net.ssl.keyStore=\"/home/bozyurt/clinical_client.ks\" -Djavax.net.ssl.keyStorePassword=<pwd>"



java -cp $CLASSPATH  org.apache.axis.client.AdminClient -s/clinical/services/AdminService -h$HOSTNAME -p$PORT $3

