#!/bin/bash

darwin=false
cygwin=false

case "`uname`" in
CYGWIN*) cygwin=true;;
Darwin*) darwin=true;;
esac

SEP=":"
if $cygwin; then
   SEP=";"
fi


if [ ! -d "$CLINICAL_HOME" ]
then
  echo ""
  echo "Cannot continue"
  echo "Please set the environment var CLINICAL_HOME to a valid directory:$CLINICAL_HOME"
  exit 1;
fi


unset CLASSPATH

for lib in "$CLINICAL_HOME"/lib/*.jar
do
  [[ "$lib" == *bootstrap.jar ]] && continue
  [[ "$lib" == *hid-client.jar ]] && continue
  if [ "$CLASSPATH" == "" ]
  then
    CLASSPATH=$lib
  else
    CLASSPATH="${CLASSPATH}${SEP}$lib"
  fi
done
CLASSPATH="$CLASSPATH${SEP}$CLINICAL_HOME/migration.jar"
CLASSPATH="$CLASSPATH${SEP}$CLINICAL_HOME/conf${SEP}."
#echo $CLASSPATH

java  -cp "$CLASSPATH"  clinical.tools.dbadmin.migration.MigrationAdmin $*

