#!/usr/bin/perl -w 
# $Id: prep_meta.pl,v 1.1.1.1 2003/10/22 19:16:00 bozyurt Exp $
use strict;
use Carp;
use DBI;

sub read_meta {
  my ($fname) = @_;
  my %series_map = ();
  my %path_map = ();
  my $cur_series = undef;
  my $cur_birnid = undef;
  open(IN, "$fname") or croak("cannot open file $fname:$!");
  while(<IN>) {
    chomp;
    my @toks = split (/\'/);
    my @new_toks = ();
    foreach my $tok (@toks) {
      next if ( $tok =~ /^\s*$/); 
      push @new_toks, $tok;
    } 
    @toks = @new_toks;
    if ($toks[0] =~ /0008(\d{8,8})/ ) {
       $cur_series = $toks[0];
       $cur_birnid = $1;
       #print "cur_birnid=$cur_birnid\n";
       if (exists $series_map{$1}) {
           my $rec = $series_map{$1};
           my %meta = %{$rec->{meta}};
           $meta{$toks[2] } = $toks[3];
           $rec->{meta} = \%meta; 
           if (length $toks[0] > length $rec->{path}) {
	       $rec->{path} = $toks[0];
           }
	   #my $count = scalar (keys %meta);
           #print("count=$count\n");
       } else {
	   
           my %meta = ();
	   $meta{ $toks[2] } = $toks[3];
           my $rec = {
             'meta' => \%meta,
             'path' => $toks[0]   
           }; 
          $series_map{$1} = $rec;
     
       }
   
    } 
  }
  close(IN); 
  return \%series_map;
}

sub dump_series_map {
    my (%series_map) = @_;
    while ( my ($key,$rec) = each %series_map) {
	print "$key\n";
        my %meta = %{$rec->{meta}};
        while( my ($name, $value) = each %meta) {
          if (defined($value)) { 
            print "\t$name=$value\n";
          } else {
	      print "\t$name=\n";
          }  
	}
        print "\tPATH=" . $rec->{path} . "\n";
    } 
}

sub to_xml {
    my ($out_fname, $ser_map_ref) = @_;
    my %ser_map = %{$ser_map_ref};
    open(OUT, ">$out_fname") or croak("Cannot create file $out_fname:$!");
    print OUT "<adrc>\n";
    while ( my ($key,$rec) = each %ser_map) {
	print "$key\n";
        my %meta = %{$rec->{meta}};
        print OUT "\t<row>\n";
        print OUT "\t\t<col name=\"path\" value=\"" .   $rec->{path} . "\"/>\n";  
        foreach my $name (sort keys %meta) {
          my $value = $meta{$name}; 
          if (defined($value)) { 
            print OUT "\t\t<col name=\"$name\" value=\"$value\"/>\n";
          } else {
              print OUT "\t\t<col name=\"$name\" value=\"\"/>\n";
          }  
	}
        print OUT "\t</row>\n"; 
    } 
    print OUT "</adrc>\n";
    close(OUT);
    print("saved XML to $out_fname!\n");
}

sub prep_equipment_script {
    my ($ser_map_ref, $owner, $mod_user, $prep_delete) = @_;
    my %ser_map = %{$ser_map_ref};
    my %equip_map=();
    while ( my ($key,$rec) = each %ser_map) {
        my %meta = %{$rec->{meta}};
        my $make = $meta{Manufacturer};
        my $model = defined($meta{Model}) ?  $meta{Model} : "";
        unless (exists $equip_map{$make}) {
           $equip_map{$make} = $model;   
	}
    }
    print("declare\n\tid NUMBER;\n") unless($prep_delete);
    print("begin\n");
    foreach my $model (sort keys %equip_map) {
        my $make = $equip_map{$model};
        if ($prep_delete) {
           print "\timgdata.delete_equipment('$model','$make','$owner','$mod_user');\n";
        } else { 
          
           print "\tid := imgdata.add_equipment('$model','$make','$owner','$mod_user');\n";
        }
    }
     print("end;\n\/\n");
}

sub do_query {
    my ($query) = @_;
    my @rows = ();
    open(PH,"sqlrunner.sh \"$query\" |") or croak("cannot exec sqlrunner.sh:$!");
    while(<PH>) {
	chomp;
        my @toks = split (/\"/);
        my @new_toks = ();
        foreach my $tok (@toks) {
          next if ( $tok =~ /^\s*$/); 
          push @new_toks, $tok;
        } 
        @toks = @new_toks;
        push @rows, \@toks;
    }
    close(PH);
    return @rows;
}

sub dump_rows {
  my ($rows_ref) = @_;
  my @rows = @{$rows_ref};
  foreach my $row_ref (@rows) {
      print join(",",@{$row_ref}) . "\n";
  } 
}

sub prep_rawdata_script {
   my ($ser_map_ref,$equip_id,$ext_name, $ont_src, $concept_id, $owner, $mod_user, $prep_delete) = @_;
   my %ser_map = %{$ser_map_ref};
   # first get and filter list of available subject scan visits
    my @rows = do_query("select componentid,NC_EXPERIMENT_UNIQUEID,subjectid from nc_expcomponent where visittype='scan'"); 
   # next determine the list of segments
    print("declare\n\tid NUMBER;\n") unless($prep_delete);
    print("begin\n");
   foreach my $row_ref (@rows) {
       my @row = @{$row_ref};
       my $key = $row[2];
       $key =~ s/UCSD//;
       my $rec = $ser_map{$key};
       my $data_uri = $rec->{path};
       my $subjectid = $row[2];
       my $componentid = $row[0];
       my $query = "select SEGMENTID,COMPONENTID,NC_EXPERIMENT_UNIQUEID, SUBJECTID from nc_expsegment where ";
       $query .= " SUBJECTID='$row[2]'  AND COMPONENTID =$row[0] AND  NC_EXPERIMENT_UNIQUEID =$row[1]";
       #print("query=$query\n");
       my @seg_rows = do_query($query);
       foreach my $ref (@seg_rows) {
	   my @r = @{$ref};
           print(" id := imgdata.add_rawdata('$data_uri','$subjectid',$equip_id,$row[1],$componentid,");
           print("$r[0],'$ext_name','$ont_src',$concept_id,'$owner','$mod_user');\n");
       }
   
   }
   print("end;\n\/\n");
}


sub test_query() {
    my @rows = do_query("select componentid,subjectid, uniqueid from nc_expcomponent where visittype='scan'");
    dump_rows(\@rows);

}

my $fname = "/home/bozyurt/dev/java/clinical/bin/all_meta.txt";
my $series_map_ref = read_meta($fname);

# dump_series_map(%{$series_map_ref});
#to_xml("/home/bozyurt/dev/java/clinical/bin/all_meta.xml", $series_map_ref);

#prep_equipment_script($series_map_ref, "ucsd_fmri", "ucsd_fmri",0);
#test_query();

prep_rawdata_script($series_map_ref,2727, "none", "UMLS", 20000, "ucsd_fmri", "ucsd_fmri", 0);
