create or replace function del_assessment(varchar) returns integer as '
declare
  as_name_in alias for $1;
  v_as_id numeric := -1;
  v_sa_id numeric := -1;
  as_cur cursor for select assessmentid from nc_assessment where name = as_name_in;
  sa_cur cursor for select s.uniqueid from nc_storedassessment s, nc_assessment a 
    where s.assessmentid = a.assessmentid and a.name = as_name_in;  
begin

  open as_cur;
  fetch as_cur into v_as_id;
  if v_as_id is NULL then
     v_as_id := -1;
  end if;
  close as_cur;
  raise notice '' v_as_id %'', v_as_id;
  if v_as_id = -1 then
     return -1;
  end if;
  open sa_cur;
  loop
    fetch sa_cur into v_sa_id;
    if v_sa_id is NULL then
      v_sa_id := -1;
      exit;
    end if;
    delete from nc_assessmentinteger where storedassessmentid = v_sa_id;
    delete from nc_assessmentvarchar where storedassessmentid = v_sa_id;
    delete from nc_assessmentfloat where storedassessmentid = v_sa_id;
    delete from nc_assessmenttimestamp where storedassessmentid = v_sa_id;
  end loop;
  close sa_cur;
  delete from nc_storedassessment where assessmentid = v_as_id;
  delete from nc_assessmentitem where assessmentid = v_as_id;
  delete from nc_assessmentscorecode where assessmentid = v_as_id;
  delete from nc_assessmentscore where assessmentid = v_as_id;
  delete from nc_assessment where assessmentid = v_as_id;
  return 0;
end;
' LANGUAGE plpgsql;


create or replace function del_assessments() returns integer as '
declare
  v_as_name varchar := NULL;
  v_rc numeric := -1;
  name_cur cursor for select name from nc_assessment;
begin
  open name_cur;
  loop
    fetch name_cur into v_as_name;
    if v_as_name is NULL then     
      exit;
    end if;
    v_rc := del_assessment(v_as_name);
  end loop;
  close name_cur;
  return 0;
end;
' LANGUAGE plpgsql;
