--
-- fixes wrong skullstripping values for skullstripping bug for automated CSF jobs.


create or replace function fix_skull_strip_provenance() returns integer as '
declare
  prov_cur cursor for select a.uniqueid from nc_job_provenance a, nc_job_provenance_param b where a.uniqueid = b.job_prov_id and b.name=''automated'' and b.value=''yes'';
 v_prov_id numeric := -1; 
begin
  open prov_cur;
  loop
    fetch prov_cur into v_prov_id;
	 if v_prov_id is NULL then
	   v_prov_id := -1;
	   exit;
	 end if;
    update nc_job_provenance_param set value=''no'' where job_prov_id = v_prov_id and name=''skullStripping'';
  end loop;
  close prov_cur;
  return 0;
end;
' LANGUAGE plpgsql;
