#!/bin/bash


output_dir=$1

cd $output_dir

am_brik=tdif+tlrc
if [ -e $output_dir/Ftest+tlrc.BRIK ]
then
  am_brik=Ftest+tlrc
fi

anat_brik="3dmerged_anat+tlrc"

Xvfb :1 -screen 0 800x800x24 &> /dev/null & 
pid=$!
afni -display :1.0 -com 'OPEN_WINDOW A.axialimage mont=10x5:3' \
     -com "SWITCH_UNDERLAY $anat_brik" \
     -com "SWITCH_OVERLAY  $am_brik" \
     -com 'SEE_OVERLAY +' \
     -com 'SET_THRESHNEW A 0.05 *p' \
     -com 'SET_PBAR_ALL A.+99 1.0 Spectrum:yellow_to_cyan+gap' \
     -com 'OPEN_WINDOW A.coronalimage mont=10x5:3' \
     -com 'OPEN_WINDOW A.sagittalimage mont=10x5:3' \
     -com 'SET_XHAIRS A.axialimage.OFF' \
     -com 'SET_XHAIRS A.coronalimage.OFF' \
     -com 'SET_XHAIRS A.sagittalimage.OFF' \
     -com "SAVE_PNG A.axialimage Axial.png" \
     -com "SAVE_PNG A.coronalimage Coronal.png" \
     -com "SAVE_PNG A.sagittalimage Sagittal.png" \
     -com 'QUIT'   

kill -9 $pid
