(function($) {
    var methods = {
       init : function(options) {
          var data = $(this).data('ratingcomp'),
                      settings = $.extend({
                       ratingControl : 'select#ratingSel',
                       reasonDiv : '#reasonDiv',
                       ratings : ['Excellent','Good','Average','Marginal','Unusable'],
                       reasons : [],
                       showReasonFor : ['Marginal','Unusable'],
                       collectUserReason : true,
                      }, options || {});
          var selEl$ = $(settings.ratingControl);
          var reasonDiv$ = $(settings.reasonDiv);
          if (!data) {
             $(this).data('ratingcomp', {settings: settings});
          }

          function createReasons() {
            var cbgDiv$,i, val, str;
            if (settings.reasons.length > 0) {
               if ( $('div.reason-cbg',reasonDiv$).size() !== 0) {
                   return;
               }
               cbgDiv$ = $('<div></div>').addClass('reason-cbg');
               for(i = 0; i < settings.reasons.length; i++) { 
                    val = settings.reasons[i];
                    str = '<input type="checkbox" name="reason" value="' + 
                    val + '" id="rcb' + i + '"></input><label for="rcb' + 
                    i + '">' + val + '</label>';
                    $('<div></div>').append($(str)).appendTo(cbgDiv$);
               }
               cbgDiv$.appendTo($(settings.reasonDiv));
               str = '<label for="userReason">Comments:</label><textarea id="userReason" cols="40" rows="3"></textarea>';
               $('<div></div>').attr('id','userReasonDiv').append($(str)).appendTo(cbgDiv$);
               $('#userReasonDiv',cbgDiv$).css({verticalAlign:'middle'}).
                  children().css('vertical-align','middle').end().hide();
               $(':checkbox',cbgDiv$).bind('change', function() {
                   var value = $(this).val();
                   if (value == 'Other') {
                      if (this.checked) {
                        $('#userReasonDiv',cbgDiv$).show();
                      } else {
                        $('#userReasonDiv',cbgDiv$).hide();
                      }
                   }
               });
            }
          }
          var ratings = settings.ratings;
          ratings.unshift('-- select a rating');
          $.populateSelect(selEl$[0],ratings, function(o) {
              return {name: o, value: o };
          });
          selEl$.bind('change', this, function(event) {
            var selVal = $(':selected',this).val();
            var found = false;
            for(var i = 0; i < settings.showReasonFor.length;i++) {
                if (selVal == settings.showReasonFor[i]) {
                   found = true;
                   break;
                }
            }
            if (found) {
               createReasons();
            } else {
                $('div.reason-cbg').remove();
            }
            $('option[value^="--"]',this).remove();
          });
          return this;
       },

       destroy : function() {
          var $this = $(this), 
              data = $this.data('ratingcomp');
          $this.removeData('ratingcomp');
          //TODO
       },
       getcollected : function() {
         // JSON
         var $this = $(this), 
             data = $this.data('ratingcomp'),
             selEl$ = $(data.settings.ratingControl),
             reasonDiv$ = $(data.settings.reasonDiv),
             result = {}, errMsg = '', found = false,i;
         var value = selEl$.val();
         if (value.indexOf('--') === 0) {
           errMsg += 'Please select a valid rating!';
           alert(errMsg);
           return null;
         }
         result.rating = value;
         for(i = 0; i < data.settings.showReasonFor.length;i++) {
           if (value == data.settings.showReasonFor[i]) {
               found = true;
               break;
           }
         }
         var cbgDiv$ = $('div.reason-cbg',reasonDiv$);
         if ( cbgDiv$.size() !== 0) {
             result.reasons = $('[name="reason"]:checked',cbgDiv$).map(
              function() { return $(this).val(); }).toArray();
             result.userComment = $('#userReason',cbgDiv$).val(); 
             if (!result.reasons || result.reasons.length == 0) {
                if (found) {
                   alert("No reason is provided for the rating:'" + value + "'!");
                   return null;
                }
            }    
            var uc = $.trim(result.userComment);
            if (uc.length === 0) {
              for(i = 0; i < result.reasons.length; i++) {
                  if (result.reasons[i] == 'Other') {
                      alert("No explanation is provided for the rating:'" + result.reasons[i] +"'!");
                      return null;
                  }
              }
            }
         }

         alert('result=' + JSON.stringify(result));
         return result;
       }
    };
    $.fn.ratingcomp = function(method) {
        if (methods[method]) {
            return methods[method].apply(this, Array.prototype.slice.call(arguments,1));
        } else if (typeof method === 'object' || !method) {
            return methods.init.apply(this, arguments);
        } else {
           $.error('Method ' + method + ' does not exist on jquery.cbfbirn.ratingcomp!');
        }
    }
})(jQuery);
