package cbfbirn

import groovy.transform.ToString;
import groovy.xml.MarkupBuilder

import java.io.File;

class PhFBIRNProjUploadInputBuilder {
	
	@ToString
	static class SubjectInfo {
		def localId
		def subjectId
		def birthDate
		def gender
		def age
		def viList = []
		
	}
	
	@ToString
	static class VisitInfo {
		def location
		def drug
		def day
	}
	
	static String normalize(String s) {
		s = s.trim()
		if (s.startsWith('"')) {
           String s1 = s.substring(1)
		   s1 = s1.substring(0, s1.length() - 1);       
	     } else return s
	}
	
	def loadSubjectInfoCSV(File csvFile) {
		def lines = []
		csvFile.text.eachLine { line, lineNo -> 
			if (lineNo > 0) lines << line;
		}
		def siList = []
		lines.each {
			def toks = it.split(/,/);
			String gender = normalize(toks[2]);
			gender = gender.equals('male') ? 'Male' : gender;
			SubjectInfo si = new SubjectInfo(localId:normalize(toks[0]), 
				subjectId:normalize(toks[1]), birthDate:toks[3], age:toks[4], gender:gender )
			siList << si;
			si.viList << new VisitInfo(day:toks[5], drug: toks[6])
			si.viList << new VisitInfo(day:toks[7], drug: toks[8])
			si.viList << new VisitInfo(day:toks[9], drug: toks[10])
		}
		// siList.each { println it }
		return siList
	}
	
	def associateWithImageData(siList, File imageRoot) {
		def visitDirs = []
		def map = [:]
		siList.each { map[it.subjectId] = it }
		imageRoot.eachFileRecurse {
		   if (it.directory && it.name.startsWith('Visit')) {
			   visitDirs << it
		   }
		}
		visitDirs.each { vd ->
			println vd
			def subjectId = vd.parentFile.name
			def visitDate = vd.name.replaceFirst('Visit_','')
			visitDate = visitDate.replaceAll('_','/')
			SubjectInfo si = map[subjectId]
			if (si == null) {
				println "missing subject:$subjectId"
			}
			assert si != null
			def vi = si.viList.find { it.day.equals(visitDate) }
			if (vi == null) {
				println "no matching visit for $visitDate of subject:$subjectId"
			}
			assert vi != null
			vi.location = vd.canonicalPath
		}
	}
	
	def writeXml(siList, File outFile) {
		def writer = new StringWriter()
		def xml = new MarkupBuilder(writer)
		xml.cbfImport() {
			for(si in siList) {
				for(vi in si.viList) {
					ds(subjectID:si.subjectId,  diagnosis:'control', expName:'phFMRI',
						visitDate: vi.day, birthDate: si.birthDate, gender: si.gender,
						scannerInfo:'GE MEDICAL SYSTEMS DISCOVERY MR750 fmri3tw',
						location: vi.location, age:si.age) {
							'as'(name:'Drug Information')	 {
								score(name:'Drug', value:vi.drug)
							}
						}
				}
			}
		}
		println writer.toString()
		if (outFile != null) {
			writeFile(outFile, writer.toString())
		}
	}
	
	def static writeFile(File outFile, String content) {
		outFile.withWriter { out -> out.write(content); out.append("\n") }
		println "wrote file:$outFile"
	}
	
	static void renameDICOMDirs(File inputRoot) {
		def anonDirs = []
		inputRoot.eachFileRecurse { f ->
			if (f.directory && f.name.endsWith('_anon')) {
				anonDirs << f
			}
		}
		anonDirs.each { dir ->
			String name = dir.name.replaceFirst('_anon$','')
			File destDir = new File(dir.getParentFile(),name);
			println "mv ${dir.canonicalPath} ${destDir.canonicalPath}"
			moveDir(dir.canonicalPath, destDir.canonicalPath);
		}
	}
	
	static void copyRawData(File srcRoot, File destRoot) {
		def visitDirs = [];
		srcRoot.eachDir {dir -> 
		   if (dir.name =~ /\d{12,12}/) {
			   dir.eachDir {sd -> 
				  if ( sd.name =~ /^Visit/ ) visitDirs << sd   
			   }
		   }	
		}
		visitDirs.each {vd ->  
			println vd 
			String relPath = vd.canonicalPath;
			relPath = relPath.substring( srcRoot.canonicalPath.size() + 1);
			println "relPath:$relPath"
			File destPath = new File(destRoot, relPath);
			destPath.mkdirs();
		    def names = getFilesDirs2Copy(vd);
			names.each { name -> println '\t' + name 
			    File src = new File(vd, name);
				
				if (src.isDirectory()) {
					File destDir = new File(destPath, name);
					println "copyDir:$src"
					copyDir(src, destDir);
				} else {
				   File destFile = new File(destPath, name);
				   copyFile(src, destFile);
				}
			}	
		}
		
	}
	
	static def getFilesDirs2Copy(File visitDir) {
		def names = []
		new File(visitDir,'CONTENTS').text.eachLine {
			line -> 
			def toks = line.split(/\s+/);
			names << toks[0];
		}
		return names
	}
	
	
	static void  moveDir(String fromDir, String toDir) {
		def ant = new AntBuilder()
		ant.move(todir:toDir) { fileset(dir:fromDir) }
	}
	
	static void copyDir(File src, File dest) {
		dest.mkdir();
		def srcFiles = []
		src.eachFile { if (it.isFile()) srcFiles << it }
		srcFiles.each { srcFile ->
			copyFile(srcFile, new File(dest, srcFile.name ));
		}
	}
	
	static void copyFile(File src, File dest) {
		new AntBuilder().copy(file:"$src.canonicalPath",tofile:"$dest.canonicalPath",overwrite:'true')
	}
	
	static void main(args) {
		// PhFBIRNProjUploadInputBuilder.copyRawData(new File("/data/cbfbirn/data/phFMRI"), new File("/data/burak/phFMRI_input"))
		// PhFBIRNProjUploadInputBuilder.renameDICOMDirs( new File('/data/burak/phFMRI_input'))
		PhFBIRNProjUploadInputBuilder builder = new PhFBIRNProjUploadInputBuilder()
		
     	def siList = builder.loadSubjectInfoCSV(new File('/home/bozyurt/dev/java/clinical/scripts/phFMRI_project/phFMRI_participants.csv'));
	    builder.associateWithImageData(siList, new File('/data/burak/phFMRI_input'))
		siList.each { println it }
		println "-" * 80
		builder.writeXml(siList, new File('/home/bozyurt/dev/java/clinical/scripts/phFMRI_project/phFMRI_data_import.xml'))
	}

}
