package fbirn

import groovy.xml.MarkupBuilder;

import java.io.File
import java.text.SimpleDateFormat

class ASLUploadInputGenerator {
	static SimpleDateFormat sdf = new SimpleDateFormat('yyyy-MM-dd HH:mm:ss.S')
	// visitDate format
	static SimpleDateFormat vdf = new SimpleDateFormat("MM/dd/yyyy")
	def sidMap = ['ucsd':'0008','uci':'0009','duke':'0003','ucsf':'0020','mrn':'0010','uiowa':'0012','umn':'0013', 
		'yale':'0018','mgh':'0006', 'bwh':'0005']
	def phase3Sites = [
		'ucsd',
		'uci',
		'duke',
		'ucsf',
		'mrn',
		'uiowa',
		'umn'
	]
	def ECTSScannerSource ectsScannerSrc = new ECTSScannerSource()
	def ECTSVisitDateSource vdSrc = new ECTSVisitDateSource()
	
	static class ECTSScannerSource {
		def sidMap = ['ucsd':'0008','uci':'0009','duke':'0003','ucsf':'0020','mrn':'0010','uiowa':'0012','umn':'0013','yale':'0018','mgh':'0006','bwh':'0005']
		def scannerMap = ['yale':'SIEMENS Trio', 'duke':'General Electric (GE) SIGNA EXCITE HD 3T', 'mgh':'SIEMENS TrioTim','bwh':'GE MEDICAL SYSTEMS SIGNA HDx']
		def invSidMap = [:]
		
		def ECTSScannerSource() {
			sidMap.each { k, v -> invSidMap[v] = k }
		}
		String getScanner(String site) {
			return scannerMap[site]
			/*
			if (si == null) {
				String key = invSidMap[site]
				return scannerMap[key]
			}
			*/
		}
	}
	
	static class Visit2Upload {
		String subjectID
		File locationDir
		String siteID
		String visitDate
		String study
		
		@Override
		public String toString() {
			return "[subjectID:$subjectID locationDir:$locationDir siteID:$siteID visitDate:$visitDate study:$study]"
		}
	}
	static class CBFDataSeriesRec {
		File locationDir
		String subjectID
		String expName
		String visitDate
		String visitID
		String scannerInfo
		String birthDate
		String gender
		String age
		String expCondition
		String site
		
		def prepBirthDate() {
			if (birthDate == null && age != null) {
				def matcher = visitDate =~ /(\d+)\/(\d+)\/(\d+)$/
				def visitYear = matcher[0][3].toInteger()
				def birthYear = visitYear - (int) Double.parseDouble(age)
				birthDate = "01/01/${birthYear}"
				println "age:$age birthDate:$birthDate visitYear:${visitYear}"
			}
		}
		@Override
		public String toString() {
			return "[locationDir:$locationDir subjectID:$subjectID expName:$expName visitDate:$visitDate\n" + 
			" visitID:$visitID gender:$gender age:$age scannerInfo:$scannerInfo expCond:$expCondition]"
		}
	}
	
	static class Demographics {
		String subjectID
		String diagnosis
		String gender
		String age
		
		static Demographics create(String line) {
			def toks = line.split(/\s+/)
			String diagnosis = toks[1].equals('P') ? "traveling schizophrenic" : "traveling control"
			String subjectID = toks[0]
			String gender = toks[2]
			String age = toks[3]
			return new Demographics(subjectID:subjectID, diagnosis:diagnosis, gender:gender, age:age)
		}
	}
	
	static class Visit {
		String subjectID
		int visitID
		String siteID
		String destVisitDir
		
		static Visit create(String line) {
			def toks = line.split(/,/)
			String s = toks[0]
			def stoks = s.split(/:/)
			Visit v = new Visit(subjectID:stoks[0],visitID:toks[1].toInteger(),siteID:stoks[2], destVisitDir:toks[2])
			return v
		}
	}
	
	def prepVisit2UploadList(destRootDir, boolean verbose=false) {
		def list = []
		File root = new File(destRootDir)
		root.eachDir { sdir ->  
			String subjectId = sdir.name
			sdir.eachDir { vdir ->  
				def visitDirName = vdir.name
				def matcher = visitDirName =~ /(\d+)_(\d+)_(\d+)_(\d+)$/
				String siteID = matcher[0][4]
				String visitDate =   matcher[0][1] + '/' + matcher[0][2] + '/' + matcher[0][3]
				def dirList = []
				vdir.eachDir { studyDir ->
					String study = studyDir.name
					if (study.equals("MRI-E") || study.equals("MRI-W") || study.equals("MRI-ge")) {
						dirList << studyDir
					}
				}
				if (dirList.empty) {
					Visit2Upload vu = new Visit2Upload(locationDir : vdir, subjectID: subjectId, 
							siteID: siteID, visitDate: visitDate, study:null)
					list << vu
				} else {
					for(studyDir in dirList) {
						String study = studyDir.name
						Visit2Upload vu = new Visit2Upload(locationDir : studyDir, subjectID: subjectId,
								siteID: siteID, visitDate: visitDate, study:study)
						list << vu
					}
				}
			}
		}
		if (verbose) {
			list.each { println it }
			println "=" * 50
		}
		return list
	}
	
	
	def  sanityCheck4ECTS() {
		def resultsDir = '/home/bozyurt/dev/java/clinical/scripts/results'
		def visitLocMap = [:]
		new File("${resultsDir}/ECTS_visitid.csv").eachLine { line ->
			Visit v = Visit.create(line)
			println "v.destVisitDir:${v.destVisitDir}"
			visitLocMap[v.destVisitDir] = v
		}
		println "visitLocMap.size:" + visitLocMap.size()
		def destVisitMap = [:]
		visitLocMap.values().each { Visit v ->  
			String key =  "${v.siteID}:${v.subjectID}:${v.visitID}"
			destVisitMap[key] = v
		}
		
		List<File> eligibleSrcVisits = MiscUtils.countEligibleVisits()
		
		println "=" * 80
		int notAccounted = 0
		for(File f in eligibleSrcVisits) {
			String visitStr = f.name
			String subjectID = f.parentFile.name
			def toks = visitStr.split(/__/)
			String siteID = toks[1]
			int visitID = toks[2].toInteger()
			String key =  "${siteID}:${subjectID}:${visitID}"
			if (destVisitMap[key] == null) {
				println f
				notAccounted++
			}
		}
		println "notAccounted: $notAccounted"
	}
	
	def prepECTSUploadInput(destRootDir) {
		String expNameRoot = "FBIRNSubject2007TE__0050"
		expNameRoot = "ECTS"
		def resultsDir = '/home/bozyurt/dev/java/clinical/scripts/results'
		def ectsSites = ['duke', 'ucsf']
		def dMap = [:]
		for(site in ectsSites) {
			extractAgeGender("${resultsDir}/as_data_FBIRNSubject2007TE__0050_${site}.xml","currentAge","Gender",dMap)
		}
		
		MiscUtils.ECTSSubjectSource ess = new MiscUtils.ECTSSubjectSource()
		
		def visitLocMap = [:] 
		new File("${resultsDir}/ECTS_visitid.csv").eachLine { line ->
			Visit v = Visit.create(line)
			println "v.destVisitDir:${v.destVisitDir}"
			visitLocMap[v.destVisitDir] = v
		}
		println "visitLocMap.size:" + visitLocMap.size()
		
		def siteSubjVDMapsMap = [:]
		for(site in ectsSites) {
			def siteMap = prepSubjVisitdate2IdMap("${resultsDir}/exp_FBIRNSubject2007TE__0050_${site}.xml")
			siteSubjVDMapsMap[site] = siteMap
		}
		
		def invSidMap = [:]
		sidMap.each { entry ->  invSidMap[entry.value] = entry.key }
		def cdsrList = []
		
		DemographicsSource demSrc = new DemographicsSource()
		
		def v2uList = prepVisit2UploadList("${destRootDir}", true)
		
		println "Number of visits to upload:" + v2uList.size()
		
		int skipCount = 0
		List<Visit2Upload> skippedList = []
		for(Visit2Upload v2u in v2uList) {
			String subjectID = v2u.subjectID
			Demographics d = dMap[subjectID]
			def vd = null
			if (d == null) {
				String age = demSrc.getAge(subjectID)
				String sex = demSrc.getGender(subjectID)
				String diagnosis = demSrc.getDiagnosis(subjectID)
				if (age != null && sex != null && diagnosis != null) {
					d = new Demographics(age:age, gender:sex, diagnosis:diagnosis)
				} else {
					
					println "*** No demographics for subject:$subjectID"
					vd = getDemographicsFromDicom(v2u.locationDir)
					if (vd != null && vd.demographics.age != null &&  vd.demographics.sex != null) {
						d = new Demographics(age:vd.demographics.age, gender:vd.demographics.sex);
						println "v2u.locationDir:${v2u.locationDir}"
						Visit vs = visitLocMap[v2u.locationDir.absolutePath]
						vd.visitId = vs.visitID
						vd.subjectID = vs.subjectID
					}
				}
				if (d == null) {
					println "*** No demographics for subject:$subjectID from DICOM either skipping..."
					skipCount++
					skippedList << v2u
					continue
				}
			} else {
				if (d.gender =~ /\d/ || d.age == "0") {
					String age = demSrc.getAge(subjectID)
					String sex = demSrc.getGender(subjectID)
					String diagnosis = demSrc.getDiagnosis(subjectID)
					if (age != null) d.age = age
					if (sex != null) d.gender = sex;
				}
			}
			
			def site = invSidMap[v2u.siteID]
			def expName = "${expNameRoot}_${site}"
			String key = "${subjectID}:${v2u.visitDate}"
			
			String visitID = null
			for(siteMap in siteSubjVDMapsMap.values()) {
				visitID = siteMap[key]
				if (visitID != null) break;
			}
			if (visitID == null) {
			    if (vd == null) {
					Visit vs = visitLocMap[v2u.locationDir.absolutePath]
					assert vs
					vd = new DicomUtils.VisitDemo()
					vd.visitId = vs.visitID
					vd.subjectID = vs.subjectID
				}
				visitID = vd.visitId
			}
			assert visitID != null
			def cdsr = new CBFDataSeriesRec(subjectID:subjectID, expName:expName,
					visitDate:v2u.visitDate, gender:d.gender, age:d.age, locationDir:v2u.locationDir,
					visitID:visitID, expCondition : d.diagnosis, site: site)
			
			cdsr.scannerInfo =  ectsScannerSrc.getScanner(site)
			
			cdsrList << cdsr
		}
		println "=" * 60
		println "** skipCount:${skipCount}"
		skippedList.each { println it }
		println "=" * 60
		println "cdsrList.size:" + cdsrList.size() + " v2uList.size:" + v2uList.size()
		for(site in ectsSites) {
			addDiagnosis("${resultsDir}/exp_FBIRNSubject2007TE__0050_${site}.xml",cdsrList)
			def sciMap = prepScannerInfoMap("${resultsDir}/img_paths_FBIRNSubject2007TE__0050_${site}.xml")
			addScanner(cdsrList, sciMap,site)
		}
		cdsrList.each { println it }
		println '-' * 50
		cdsr2Xml(cdsrList, new File("/home/bozyurt/dev/java/clinical/scripts/fbirn_import/ects_import.xml"))
	}
	
	// visitDate format 11/28/2007
	def extractVisitDate(File locationDir) {
		File seriesDir = null
		locationDir.eachDir { dir -> if (dir.name == 'B0_mag1')  seriesDir = dir }
		
		if (seriesDir == null) { return null
		}
		def dicomTarBalls = []
		def imageWrapperFile = null
		def files = []
		seriesDir.eachFileRecurse { files << it }
		
		
		files.each { f ->
			if (isDicomTarBall(f)) dicomTarBalls << f
			if (f.name.equals('ImageWrapper.xml')) imageWrapperFile = f
		}
		
		File dicomDir = null
		if (imageWrapperFile == null){
			if (dicomTarBalls.size() > 0) {
				File destDir = new File("/tmp/ects")
				destDir.mkdir()
				dicomDir = new File(destRoot,'DICOM')
				if (dicomDir.directory) {
					// delete tmpDir and all its contents
					new AntBuilder().delete(dir: dicomDir.canonicalPath)
				}
				extractTarBall(dicomTarBalls[0].canonicalPath, destDir.canonicalPath)
				assert dicomDir.directory
				files = []
				dicomDir.eachFile { f ->  if (f.name.equals('ImageWrapper.xml')) imageWrapperFile = f }
			} else {
				return null
			}
		}
		
		if (imageWrapperFile != null) {
			def visitDateStr = null
			def xml = new XmlSlurper().parse(imageWrapperFile)
			xml.acqProtocol[0].acqParam.each { ap ->
				def name = ap.'@name'
				if (name.equals("scandate") /*|| name.equals("psddate")*/) {
					String s = ap.text()
					if (visitDateStr == null && s.trim().length() > 0) {
						visitDateStr = s
					}
				}
			}
			if (visitDateStr != null) {
				def toks = visitDateStr.split(/-/)
				String vt = "${toks[1]}/${toks[2]}/${toks[0]}"
				return vt;
			}
			return null
		}
		return null
	}
	
	def prepPhase3UploadInput(destRootDir) {
		String expNameRoot = "fBIRNPhaseIII__0090"
		def resultsDir = '/home/bozyurt/dev/java/clinical/scripts/results'
		
		def dMap = [:]
		for(site in phase3Sites) {
			extractAgeGender("${resultsDir}/as_data_fBIRNPhaseIII__0090_${site}.xml","nDEMOG_CUR_AGE","sDEMOG_GENDER",dMap)
		}
		def siteSubjVDMapsMap = [:]
		for(site in phase3Sites) {
			def siteMap = prepSubjVisitdate2IdMap("${resultsDir}/exp_fBIRNPhaseIII__0090_${site}.xml")
			siteSubjVDMapsMap[site] = siteMap
		}
		
		def invSidMap = [:]
		sidMap.each { entry ->  invSidMap[entry.value] = entry.key }
		
		def cdsrList = []
		for(site in phase3Sites) {
			def v2uList = prepVisit2UploadList("${destRootDir}/${site}", true)
			for(Visit2Upload v2u in v2uList) {
				String subjectID = v2u.subjectID
				Demographics d = dMap[subjectID]
				if (d == null) {
					println "*** No demographics for subject:$subjectID"
					continue
				}
				def expName = "${expNameRoot}_${site}"
				String key = "${subjectID}:${v2u.visitDate}"
				
				String visitID = null
				for(siteMap in siteSubjVDMapsMap.values()) {
					visitID = siteMap[key]
					if (visitID != null) break;
				}
				assert visitID != null
				def cdsr = new CBFDataSeriesRec(subjectID:subjectID, expName:expName,
						visitDate:v2u.visitDate, gender:d.gender, age:d.age, locationDir:v2u.locationDir,
						visitID:visitID, expCondition : d.diagnosis, site: site)
				cdsrList << cdsr
			}
		}		
		for(site in phase3Sites) {
			addDiagnosis("${resultsDir}/exp_fBIRNPhaseIII__0090_${site}.xml",cdsrList)
			def sciMap = prepScannerInfoMap("${resultsDir}/img_paths_fBIRNPhaseIII__0090_${site}.xml")
			addScanner(cdsrList, sciMap,site)
		}
		
		// cdsrList.each { cdsr ->  crossRefWithDicomData(cdsr) }
		
		cdsrList.each { println it }
		println '-' * 50
		
		cdsr2Xml(cdsrList, new File("/home/bozyurt/dev/java/clinical/scripts/fbirn_import/phase3_import.xml"))
	}
	
	def getDemographicsFromDicom(File locationDir) {
		File t1Dir = null
		locationDir.eachDir { if (it.name == 't1') t1Dir = it }
		if (t1Dir == null) { 
			// println ">>> not t1 dir under ${locationDir}"
			locationDir.eachDir { if (it.name == 'fm1' || it.name =~ /^B0_/) t1Dir = it }
			if (t1Dir == null) {
				println ">>> not t1/fieldmap DICOM dir under ${locationDir}"
				return null
			}
		}
		DicomUtils.VisitDemo vd = DicomUtils.getVisitInfo(t1Dir);
		return vd
	}
	
	def crossRefWithDicomData(CBFDataSeriesRec cdsr) {
		DicomUtils.Demographics d = DicomUtils.getDemographics(cdsr.locationDir)
		boolean mismatch = false;
		if (d != null) {
			if (cdsr.age.toInteger() != d.age) {
				println "*** Age Mismatch (${cdsr.subjectID}) age:${cdsr.age} age (from DICOM): ${d.age}}"
				mismatch = true
			}
			if (cdsr.gender != d.sex) {
				println "*** Gender Mismatch (${cdsr.subjectID}) gender:${cdsr.gender} gender (from DICOM): ${d.sex}}"
				mismatch = true
			}
			if (mismatch) {
				println "*** ${cdsr.locationDir}"
			}
		}
	}
	
	def prepWCTSUploadInput(destRootDir, demographicsFile) {
		String expNameRoot = "FBIRNSubject2007TW__0051"
		def dMap = [:]
		new File(demographicsFile).eachLine { line ->  
			Demographics d = Demographics.create(line)
			dMap[d.subjectID] = d
		}
		def resultsDir = '/home/bozyurt/dev/java/clinical/scripts/results'
		
		def uciMap = prepSubjVisitdate2IdMap("${resultsDir}/exp_FBIRNSubject2007TW__0051_uci.xml")
		def ucsdMap = prepSubjVisitdate2IdMap("${resultsDir}/exp_FBIRNSubject2007TW__0051_ucsd.xml")
		def invSidMap = [:]
		sidMap.each { entry ->  invSidMap[entry.value] = entry.key }
		def v2uList = prepVisit2UploadList(destRootDir, true)
		def cdsrList = []
		for(Visit2Upload v2u in v2uList) {
			String subjectID = v2u.subjectID
			Demographics d = dMap[subjectID]
			if (d == null) {
				println "*** No demographics for subject:$subjectID"
				continue
			}
			String site = invSidMap[v2u.siteID]
			assert site != null
			def expName = "${expNameRoot}_${site}"
			String key = "${subjectID}:${v2u.visitDate}"
			String visitID = uciMap[key]
			if (visitID == null) {
				visitID = ucsdMap[key]
			}
			assert visitID != null
			def cdsr = new CBFDataSeriesRec(subjectID:subjectID, expName:expName,
					visitDate:v2u.visitDate, gender:d.gender, age:d.age, locationDir:v2u.locationDir, 
					visitID:visitID, expCondition : d.diagnosis, site: site)
			cdsrList << cdsr
		}
		
		// addScannerInfo("${resultsDir}/img_paths_FBIRNSubject2007TW__0051_ucsd.xml", cdsrMap)
		// addScannerInfo("${resultsDir}/img_paths_FBIRNSubject2007TW__0051_uci.xml", cdsrMap)
		def uciScanMap = prepScannerInfoMap("${resultsDir}/img_paths_FBIRNSubject2007TW__0051_uci.xml")
		def ucsdScanMap = prepScannerInfoMap("${resultsDir}/img_paths_FBIRNSubject2007TW__0051_ucsd.xml")
		addScanner(cdsrList, uciScanMap,'uci')
		addScanner(cdsrList, ucsdScanMap,'ucsd')
		cdsrList.each { println it }
		println '-' * 50
		cdsr2Xml(cdsrList, new File("/home/bozyurt/dev/java/clinical/scripts/fbirn_import/wcts_import.xml"))
	}
	
	def public static cdsr2Xml(cdsrList, File outXmlFile) {
		def writer = new StringWriter()
		def builder = new MarkupBuilder(writer)
		def filteredList = []
		cdsrList.each { cdsr ->  
			if (cdsr.locationDir == null || cdsr.scannerInfo == null ) {
				println "** Missing parameters: " + cdsr.toString()
			} else {
				filteredList << cdsr
			}
		}
		
		def cbfImport = builder.cbfImport() {
			for(CBFDataSeriesRec cdsr : filteredList) {
				cdsr.prepBirthDate()
				ds(subjectID:cdsr.subjectID, diagnosis:cdsr.expCondition, expName: cdsr.expName, 
						visitDate: cdsr.visitDate, birthDate: cdsr.birthDate, gender: cdsr.gender, 
						scannerInfo: cdsr.scannerInfo, location: cdsr.locationDir.canonicalPath)
			}
		}
		String s = writer.toString()
		println s
		writeFile(outXmlFile, s)
	}
	
	def static writeFile(File outFile, String content) {
		outFile.withWriter { out -> out.write(content); out.append("\n") }
		println "wrote file:$outFile"
	}
	
	def addScanner(cdsrList, siteScanMap, String site) {
		cdsrList.each { cdsr ->
			if (site.equals(cdsr.site)) {
				String key = "${cdsr.subjectID}:${cdsr.visitID}"
				def list = siteScanMap[key]
				if (list != null) {
					// assert list != null, "no scanners for key:$key"
					// UCSD exception
					if (site.equals("ucsd") ) {
						String name = cdsr.locationDir.name
						for(String scannerInfo in list) {
							// println "scannerInfo:$scannerInfo"
							if (scannerInfo.endsWith("East") && name.equals("MRI-E")) {
								cdsr.scannerInfo = scannerInfo;
							} else if (scannerInfo.endsWith("West") && name.equals("MRI-W")) {
								cdsr.scannerInfo = scannerInfo;
							} else if (name.equals("MRI-ge")) {
								// phase 3 only one scanner no Verio ASL data
								cdsr.scannerInfo = scannerInfo;
							}
						}
					} else {
						assert list.size() == 1
						cdsr.scannerInfo = list[0]
					}
				}
			}
		}
	}
	
	def prepScannerInfoMap(imgDataXmlFile) {
		def map = [:]
		def xml = new XmlSlurper().parse(imgDataXmlFile)
		
		xml.rawData.each {rd ->
			String subjectID = rd.'@subjectid'
			String visitID = rd.'@componentid'
			String make = rd.'@make'
			String model = rd.'@model'
			String protocolId = rd.'@protocolid'
			if (protocolId.equalsIgnoreCase('t1')) {
				String key = "${subjectID}:${visitID}"
				String scannerInfo = "$make $model"
				def list = map[key]
				if (list == null) {
					list = []
					map[key] = list
				}
				if (!list.contains(scannerInfo)) {
					list << scannerInfo
				}
			}
		}
		return map
	}
	
	
	def addScannerInfo(imgDataXmlFile, cdsrMap) {
		def map = [:]
		cdsrMap.values().each { cdsr ->  
			String key = "${cdsr.subjectID}:${cdsr.visitID}"
			assert !map.containsKey(key), "duplicate key:$key"
			map[key] = cdsr
		}
		
		def xml = new XmlSlurper().parse(imgDataXmlFile) 
		
		xml.rawData.each {rd -> 
			String subjectID = rd.'@subjectid'
			String visitID = rd.'@componentid'
			String make = rd.'@make'
			String model = rd.'@model'	
			String protocolId = rd.'@protocolid'
			if (protocolId.equalsIgnoreCase('t1')) {
				String key = "${subjectID}:${visitID}"
				def cdsr = map[key]
				assert cdsr != null
				cdsr.scannerInfo = "$make $model"
			}
		}
	}
	
	def addDiagnosis(xmlFile, cdsrList) {
		def map = prepSubject2DiagnosisMap(xmlFile)
		cdsrList.each { cdsr ->  
			def diagnosis = map[cdsr.subjectID]
			if (diagnosis != null) {
				cdsr.expCondition = diagnosis
			}
		}
	}
	
	def prepSubject2DiagnosisMap(xmlFile) {
		def map = [:]
		def xml = new XmlSlurper().parse(xmlFile)
		xml.subjects[0].subjExp.each { se ->  
			String subjectID = se.'@subjectid'
			String group = se.'@group'
			map[subjectID] = group
		}
		return map
	}
	
	def prepSubjVisitdate2IdMap(expXmlFile) {
		def map = [:]
		def xml = new XmlSlurper().parse(expXmlFile)
		xml.subjects[0].subjExp.each { se ->
			se.visit.each { v ->
				String subjectID = v.'@subjectid'
				String timeStamp = v.'@timeStamp'
				String visitId = v.'@componentid'
				if (timeStamp.trim().length() == 0) {
					println "subjectID:$subjectID"
				}
				String visitDate = toVisitDate(timeStamp)
				String key = "${subjectID}:$visitDate"
				map[key] = visitId
			}
		}
		return map
	}
	
	def extractAgeGender(xmlFile, ageScore, genderScore, demoMap) {
		def xml = new XmlSlurper().parse(xmlFile)
		xml.values[0].storedas.each { sa ->
			String subjectID = sa.'@subjectid'
			String timeStamp = sa.'@timeStamp'
			String key = subjectID
			String age = null
			String gender = null
			sa.asval.each { av ->
				String sn = av.'@scorename'
				if (sn.equals(ageScore)) {
					age = av.'@textvalue'
				} else if (sn.equals(genderScore)) {
					gender = av.'@textvalue'
				}
			}
			if (age != null && gender != null) {
				println subjectID + " key:$key age:$age gender:$gender [$timeStamp]"
				Demographics d = new Demographics(subjectID:subjectID, gender:gender, age:age)
				demoMap[subjectID] = d
			}
		}
	}
	
	def extractMinDemographics(xmlFile, ageScore, genderScore, expName) {
		// nDEMOG_CUR_AGE, sDEMOG_GENDER
		def cdsrMap = [:]
		def xml = new XmlSlurper().parse(xmlFile)
		xml.values[0].storedas.each { sa -> 
			String subjectID = sa.'@subjectid'
			String timeStamp = sa.'@timeStamp'
			String visitId = sa.'@componentid'
			String visitDate = toVisitDate(timeStamp)
			// String key = getKey(subjectID,visitDate, visitId)
			String key = subjectID
			String age = null
			String gender = null
			sa.asval.each { av ->  
				String sn = av.'@scorename'
				if (sn.equals(ageScore)) {
					age = av.'@textvalue'
				} else if (sn.equals(genderScore)) {
					gender = av.'@textvalue'
				}
			}
			if (age != null && gender != null) {
				println subjectID + " key:$key age:$age gender:$gender"
				def cdsr = cdsrMap[key]
				assert cdsr == null
				cdsr = new CBFDataSeriesRec(subjectID:subjectID, expName:expName, 
						visitDate:visitDate, gender:gender, age:age, visitID:visitId)
				cdsrMap[key] = cdsr
			}
		}
		return cdsrMap
	}
	
	def static toVisitDate(String ts) {
		Date d = sdf.parse(ts)
		return vdf.format(d)
	}
	
	def static String getKey(String subjectID, String visitDate, String visitId) {
		return "${subjectID}:${visitDate}:${visitId}"
	}
	
	
	static void test2() {
		ASLUploadInputGenerator gen = new ASLUploadInputGenerator()
		def destRootDir = "/data/bozyurt/cbfbirn/upload/FBIRNSubject2007TE__0050"
		gen.prepECTSUploadInput(destRootDir)
		// gen.sanityCheck4ECTS()
	}
	
	static void test1() {
		ASLUploadInputGenerator gen = new ASLUploadInputGenerator()
		def xmlFile = "/home/bozyurt/dev/java/clinical/scripts/results/as_data_fBIRNPhaseIII__0090_ucsf.xml"
		xmlFile = "/home/bozyurt/dev/java/clinical/scripts/results/as_data_FBIRNSubject2007TW__0051_uci.xml"
		// gen.extractMinDemographics(xmlFile, 'nDEMOG_CUR_AGE','sDEMOG_GENDER','fBIRNPhaseIII__0090')
		
		println "-" * 50
		// gen.prepVisit2UploadList('/data/bozyurt/cbfbirn/upload/FBIRNSubject2007TW__0051')
		
		String destRootDir = '/data/bozyurt/cbfbirn/upload/FBIRNSubject2007TW__0051'
		String demographicsFile = '/home/bozyurt/dev/java/clinical/scripts/results/WCTS_demographics.txt'
		// gen.prepWCTSUploadInput(destRootDir, demographicsFile)
		
		destRootDir = "/data/bozyurt/cbfbirn/upload/fBIRNPhaseIII__0090"
		gen.prepPhase3UploadInput(destRootDir)
	}
	static void main(args) {
		test2()
	}
}
