package fbirn

import java.util.Date;
import java.util.Set;

class CBFBirnDataSeriesSummarizer {
	
	static class Project {
		String name
		List<Subject> subjects = []
		int numVisitsWithFullASL = 0
		int numVisits = 0
		int numVisitsWithFieldMap = 0
		
		def showStats() {
			println "Project:$name"
			println "# of subjects:" + subjects.size()
			numVisits = 0
			subjects.each { s -> numVisits += s.visits.size() }
			println "# of visits: $numVisits"
			Closure predicate = {  return it.hasFieldMap }
			numVisitsWithFieldMap = 0
			subjects.each { Subject s -> numVisitsWithFieldMap += s.countVisitsHaving(predicate)}
			println "# of visits with field map: $numVisitsWithFieldMap"
			
			predicate= { return it.hasASL && it.hasMincon && it.hasCSF }
			numVisitsWithFullASL = 0
			subjects.each { Subject s -> numVisitsWithFullASL += s.countVisitsHaving(predicate)}
			println "# of visits with full ASL: $numVisitsWithFullASL"
		}
	}
	
	static class Subject {
		String subjectID;
		List<Visit> visits = []
		
		def countVisitsHaving(Closure predicate) {
			int count = 0
			visits.each { v -> 
				if (predicate(v)) { 
					count++
				} else {
				  //  println "predicate failed on ${v.name} of ${subjectID}"
				}
			}
			return count
		}
	}
	static class Visit {
		String name;
		boolean hasDerived = false;
		boolean hasFieldMap = false;
		boolean hasAnat = false
		boolean hasASL = false
		boolean hasMincon = false
		boolean hasCSF = false
	}
	
	
	def static collectStats(File cbfbirnDSRoot, Set<String> excludedProjects) {
		List<File> projectList = []
		List<File> projectDirs = []
		cbfbirnDSRoot.eachDir { dir ->  
			if (isAValidProjectDir(dir) && !excludedProjects.contains(dir.name)) {
				projectDirs << dir
			}
		}
		for(File projectDir in projectDirs) {
			Project proj = new Project(name:projectDir.name)
			projectList << proj
			projectDir.eachDir { dir ->  
				if (dir.name.startsWith("00")) {
					Subject subject = new Subject(subjectID:dir.name)
					proj.subjects << subject
					dir.eachDir { vd ->
						if (vd.name.startsWith("Visit")) {
							Visit v = new Visit(name: vd.name);
							if (hasSubdir(vd,"derived")) {
								v.hasDerived = true
							}
							checkASLDirs(vd, v)
							subject.visits << v
						}
					}
				}
			}
		}
		return projectList
	}
	
	def static isAValidProjectDir(File dir) {
		def dirs = []
		dir.eachDir { if (it.name.startsWith("00")) dirs << it }
		return dirs.size() > 0
	}
	def static checkASLDirs(File vd, Visit v) {
		def files = []
		File contentsFile = null
		vd.eachFile { f ->  
			String name = f.name
			if (f.file && name == 'CONTENTS') {
				contentsFile = f
			}	else {
				files << f
			}
		}
		if (contentsFile == null) {
			println "missing CONTENTS file vd:$vd"
			return
		}
		assert contentsFile, "vd:$vd"
		contentsFile.eachLine { String line ->  
			def toks = line.split(/\s+/)
			if (toks.size() >= 3) {
				assert toks.size() >= 3, "bad line:$line - $contentsFile"
				String sname = toks[0]
				String type = toks[1]
				type = type.replaceFirst(/\+CSF$/, '');
				def filtered = files.grep { it.name == sname }
				if (filtered.size() > 0) {
					switch(type) {
						case "CSF" : v.hasCSF = true; break
						case "Mincon" : v.hasMincon = true; break
						case "Field" : v.hasFieldMap = true; break
						case "Anatomical" : v.hasAnat = true; break;
						case "FAIR": 
						case "PCASL":
						case "VSASL":
						case "4MP-PCASL":
						case "8MP-PCASL":
						case "Opt-PCASL":
						case "PICORE":
						case "Opt-PCASL-Calib":
						case "EPISTAR":
							v.hasASL = true;
					}
				}
			}
		}
	}
	
	def static hasSubdir(File rootDir, String subDirName) {
		def dirs = []
		rootDir.eachDir { if (it.name == subDirName) dirs << it }
		return dirs.size() > 0
	}
	
	public static void main(String[] args) {
		Set<String> excludedProjSet = ['ASL','Demo','test','Trouble_Shoot']
		excludedProjSet = ['ASL','Demo','test','Trouble_Shoot','ASL_22x','analysis',
			'22_dev_tests','Kremen_Test_Project','Test_ucsf','Tapert_Test_Project',
			'Elyer_Beta_Project','EEG_Afternoon_Proj','EEG_Morning_Proj', 
			'Test_Experiment']
		File cbfbirnDSRoot = new File("/home/bozyurt/data")
		// cbfbirnDSRoot = new File("/data/cbfbirn/data")
		def projList = collectStats(cbfbirnDSRoot, excludedProjSet)
		int totNumVisits = 0
		int totNumVisitsWithFullASL = 0
		println new Date()
		println "=" * 80
		projList.each { Project proj ->
			proj.showStats()	  
			println "-" * 40
			totNumVisits += proj.numVisits
			totNumVisitsWithFullASL += proj.numVisitsWithFullASL
		}
		println "totNumVisits: $totNumVisits"
		println "totNumVisitsWithFullASL: $totNumVisitsWithFullASL"
	}
}
