package fbirn

class SeriesInfoExtractor {
	static class Result {
		def seriesName
		def sdMap
		
		def show() {
			println "$seriesName - Series Descriptions"
			println '-' * 40
			sdMap.keySet().sort().each { println it }
		}
		
	}
	def getDicomSeriesDesc(File dcmFile) {
		def cmd = """dcmdump ${dcmFile.absolutePath}"""
		def proc = cmd.execute()
		proc.waitFor()
		def lines = []
		proc.in.text.eachLine { if (it =~ /SeriesDesc/) lines << it }
		if (lines.empty) return null
		def m = lines[0] =~ /\[([^\]]+)\]/
		return m[0][1]
	}
	
	def compileSeriesDescs(File rootDir, String seriesName) {
		def dirs = []
		rootDir.eachFileRecurse { if (it.directory) dirs << it }
		def t1Dirs = dirs.findAll { it.name == seriesName}
		dirs = null
		t1Dirs.each { println it }
		def sdMap = [:]
		t1Dirs.each { dir ->
			def dcmFiles = []
			dir.eachFile { if (!(it.name =~ /\.xml$/)) dcmFiles << it }
			def serDesc = getDicomSeriesDesc(dcmFiles[0])
			sdMap[serDesc] = serDesc
		}
		println "$seriesName - Series Descriptions"
		println '-' * 40
		sdMap.keySet().sort().each { println it }
	}
	
	
	def compileSeriesDescsByPattern(File rootDir, String seriesNamePattern) {
		def dirs = []
		rootDir.eachFileRecurse { if (it.directory) dirs << it }
		def t1Dirs = dirs.findAll { it.name =~ /$seriesNamePattern/ }
		dirs = null
		// t1Dirs.each { println it }
		def sdMap = [:]
		for(dir in t1Dirs) {
			def dcmTarBalls = []
			dir.eachFileRecurse { if (it.name =~ /^DICOM\.tar\.gz$/) dcmTarBalls << it }
			if (!dcmTarBalls.empty) {
				// println "handling $dir"
				File destDir = new File('/tmp/SeriesInfoExtractor_scratch')
				destDir.mkdir()
				extractTarBall(dcmTarBalls[0].canonicalPath, destDir.canonicalPath)
				def dcmFiles = []
				destDir.eachFileRecurse { if (it.file && !(it.name =~ /\.xml$/)) dcmFiles << it }
				def serDesc = getDicomSeriesDesc(dcmFiles[0])
				println ">> $serDesc [" + dir.name + "] - " + dir
				if (!sdMap.containsKey(serDesc)) {
					sdMap[serDesc] = serDesc
				}
				cleanDir(destDir)
			}
		}
		println "$seriesNamePattern - Series Descriptions"
		println '-' * 40
		sdMap.keySet().sort().each { println it }
		
		return new Result(seriesName:seriesNamePattern, sdMap: sdMap)
	}
	
	
	def extractTarBall(String tarballPath, String dest) {
		def ant = new AntBuilder()
		ant.untar(src:tarballPath, dest:dest,compression:"gzip")
	}
	
	def cleanDir(File dir) {
		new AntBuilder().delete(dir: dir.canonicalPath)
	}
	static void main(args) {
		def toUploadRoot = "/data/bozyurt/cbfbirn/upload/FBIRNSubject2007TW__0051"
		SeriesInfoExtractor sie = new SeriesInfoExtractor()
		// sie.compileSeriesDescs(new File(toUploadRoot),'asl_calibration')
		// sie.compileSeriesDescs(new File(toUploadRoot),'asl_mincon')
		// sie.compileSeriesDescs(new File(toUploadRoot),'asl_WIP')
		sie.compileSeriesDescs(new File(toUploadRoot),'t1')
		
		def srcRoot = "/data/bozyurt/fbirn/FBIRNSubject2007TW__0051"
		// sie.compileSeriesDescsByPattern(new File(srcRoot), /^B0_/)
		
		srcRoot = "/data/bozyurt/fbirn/fBIRNPhaseIII__0090/duke"
		srcRoot = "/data/bozyurt/fbirn/fBIRNPhaseIII__0090/"
		def sites = [
			'duke',
			'ucsd',
			'uci',
			'ucsf',
			'mrn',
			'uiowa',
			//'umn'
		]
		def site = sites[2];
		
		def results = []
		def result = null
		srcRoot = "/data/bozyurt/fbirn/fBIRNPhaseIII__0090/$site"
		
		/*
	    result = sie.compileSeriesDescsByPattern(new File(srcRoot), /^asl_calibration/)
		results << result
	    result = sie.compileSeriesDescsByPattern(new File(srcRoot), /^asl_mincon/)
		results << result
		
		result = sie.compileSeriesDescsByPattern(new File(srcRoot), /^asl_fairest/)
		results << result
		
		result = sie.compileSeriesDescsByPattern(new File(srcRoot), /^t1$/)
		results << result
*/		
		result = sie.compileSeriesDescsByPattern(new File(srcRoot), /^B0_/)
		results << result
		
		results.each { r -> r.show() }
	}
}
