import groovy.sql.Sql;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: DataAccessObject.groovy,v 1.1 2009/04/14 00:07:28 bozyurt Exp $
 */

abstract class DataAccessObject {
    Sql db;
    String dbType = "postgres";
    int ownerID = 88;   //89; // oracle
    String modTimeCmd = 'now()'; //  'SYSDATE';
    String tableIDTable = "nc_tableid";
    String tableName = null;
	
	abstract List getFields()
	
	void setOwner(dbu) {
	   ownerID = dbu.uniqueid;
	}
	
	void setDBType(String dbType) {
	  this.dbType = dbType;
	  if (dbType == 'postgres') {
	    this.modTimeCmd = 'now()';
	  } else {
	     this.modTimeCmd = 'SYSDATE';
	  }
	}
	
	def getWhereId() { "where uniqueid = ?" }
	def dataSet() { db.dataSet(tablename) }
	
	String getTablename() {
	    if (tableName == null) {
		  def name = this.getClass().name;
		  name = "nc_" + name[name.lastIndexOf('.')+1..-4].toLowerCase();
		  return name
		} else 
		  return tableName;
	}
	
	def create(List args) {
		Map argMap = [:];
		args.eachWithIndex { arg, idx -> argMap[ fieldNames[idx] ] = arg }
	    dataSet().add(argMap);			              
	}
	
	def getFieldNames() {
		return fields;
	}
	
	def update(field, newValue, uniqueId) {
	   def sql = "update $tablename set $field = ? $whereId";
	   println "update:$sql"
	   db.executeUpdate stmt, [ newValue, uniqueId]
	}
	
	def find(wherePart = null, sortField = null) {
		def selects = fieldNames;
		def results = [];
		def sql = "select  " + selects.join(',') + " from $tablename "
		if ( wherePart) sql += "$wherePart ";
		if ( sortField) sql +=	"order by $sortField";
		println "sql:$sql"
		db.eachRow(sql.toString()) { rs ->
			Map vo = [:];
			selects.each { vo[it] = rs[it]; }
			results << vo
		}
		return results;
	}
	
	def delete(Map argMap) {
	   if (argMap) {
		   def sql = "delete from $tablename where ";
		   argMap.each { field, value -> sql <<= "$field = $value AND ";}
		   sql = sql[0..-5];
		   print "delete:$sql"
		   db.executeUpdate sql, [];
	   }
	}
	
	def getBoolean(int value) {
		if (dbType == 'postgres') {
			return value >= 1;
		} else {
			return value;
		}
	}
	
	def dumpVO(vo) {
		def fmt = new java.text.SimpleDateFormat('dd MMM yyy (HH:mm:ss)', Locale.US)	
		def s = "";
		fieldNames.each { fn ->
		    def value = vo["$fn"];
		    if ( value instanceof java.sql.Date) {
		    	value = fmt.format(value);
		    } else if (value instanceof oracle.sql.DATE) {
		    	value = OracleUtils.getTimestamp(value)
		    }
			s <<= "${value},"	
		}
		s = s[0..-2];
		println s;
	}
	
	def toXML(vo) {
		def fmt = new java.text.SimpleDateFormat('dd MMM yyy (HH:mm:ss)', Locale.US)	
		def s = "";
		fieldNames.each { fn ->
		    def value = vo["$fn"];
		    if ( value instanceof java.sql.Date) {
		    	value = fmt.format(value);
		    } else if (value instanceof oracle.sql.DATE) {
		    	value = OracleUtils.getTimestamp(value)
		    }
			s <<= "<column name=\"$fn\" value=\"${value}\"/>\n"	
		}		
	}
	
	def nextUID() {
		def uid = -1;
		if ( dbType == 'postgres') {
			db.eachRow("select nextval('uid_seq')") { row -> uid = row[0] }	
		} else {
    	    db.eachRow('select uid_seq.nextval from dual') { row -> uid = row[0] }
		}
    	return uid;
	}
	
	def getTableID() {
		def uid = -1;
		def sql = "select uniqueid from " + tableIDTable + " where tablename = '" + tablename.toUpperCase()  + "'";
		println("sql:$sql")	
		db.eachRow(sql) { row -> uid = row[0] }
		return uid;
	}
	
	def prepInsertQuery(Map argMap, Map defMap, boolean verbose = true) {
		argMap.each { name, value -> 
	      defMap[name] = value;
	    }
	    def sql = "insert into $tablename (" + defMap.keySet().join(',') + ") values(" +
	       defMap.values().join(',') + ")";
	    if (verbose)
	    	println "create: $sql";
	    return sql;
	}

}
