class GenUtils {

 static isWindows() {
	 return System.getProperty('os.name').toLowerCase().startsWith('windows');
 }
  static adjustPath(String path) {
	  def isWindows = System.getProperty('os.name').toLowerCase().startsWith('windows');
	  if ( isWindows && path.indexOf('c:/cygwin') == -1) {
		  if ( path.startsWith('/')) {
			  return 'c:/cygwin' + path;
		  } else {
			  return 'c:/cygwin/' + path;
		  }
	  }
	  return path;
  }
  
  static Properties loadProperties(String propsFile) {
	  InputStream is = GenUtils.class.getClassLoader().getResourceAsStream(
				propsFile)
	  def props = new Properties()
	  props.load(is)
	  return props;
  }
  
  /**
    * returns the total size (in bytes) of a the contents of a directory.
    */
  static def dirSize(String dir) {
	  def size = 0;
	  def directory = new File(dir);
	  if (! directory.directory) return directory.length();
	  directory.eachFileRecurse { if (it.file) size += it.length() }
	  return size;
  }

  static void main(args) {
	  def dir = "/home/bozyurt/dev/java/branch/BIRN/clinical/src"
	  def size = dirSize(dir);
	  println "$dir size : $size bytes."
  }
}
