package gtools.utils;

import groovy.sql.Sql;
import groovy.xml.MarkupBuilder;
import clinical.server.utils.OracleUtils;


class DataObjectDAO extends DataAccessObject {
	List getFields() {
		// return ['uniqueid','tableid', 'owner', 'modtime', 'moduser', 'extensionname',
		//        'dataid','objecttype', 'objectname', 'objectsize', 'description'];
		return ['uniqueid','tableid', 'owner', 'modtime', 'moduser', 'extensionname',
		        'dataid','objecttypeid', 'objectname', 'objectsize', 'description'];
	}
	
	def create(Map argMap) {
    	def uid = nextUID();
    	def map = [description: null, objectname : null, modtime : 'SYSDATE' ];
       	argMap['extensionname'] = "'" + argMap['extensionname'] + "'";
       	argMap.remove('modtime');
       	
       	def sql = prepInsertQuery(argMap, map, true);
       	db.executeUpdate sql, [];
    }
}//;

class DataObjectTypeDAO extends DataAccessObject {
	List getFields() {
		return ['uniqueid','tableid', 'owner', 'modtime', 'moduser',
		        'objecttype','applicableactions','description'];
	}
}//;

class DataObjectExportImport {
	static def getDb() {
		  def props = GenUtils.loadProperties("gtools.properties")
		  assert props
		  def db = Sql.newInstance(props.getProperty('db.url'), 
		    		 props.getProperty('db.user'),props.getProperty('db.pwd'),  
		    		 'oracle.jdbc.driver.OracleDriver');
		  
	  }
	
	
  static void exportOldDataObjects(def outFile=null) {
	 def db = getDb();
	 DataObjectDAO dao = new DataObjectDAO(db: db);
	
	 def doList = dao.find();
	
	 def writer = new StringWriter();
	 def xml = new MarkupBuilder(writer);
	 xml.'table-dump'(name:'nc_dataobject') {
		 for (dataObj in doList) {
			 record() {
				 for(fn in dao.fieldNames) {
					 def value = dataObj["$fn"];
					 if (value) {
					   if ( value instanceof java.sql.Date) {
					    	value = fmt.format(value);
					   } else if (value instanceof oracle.sql.DATE) {
					    	value = OracleUtils.getTimestamp(value)
					   }
					 } else {
						 value = "NULL";
					 }
					 column(name:fn, value: value)
				 }
			 }
		 }
	 }
	 println writer.toString()
	 if (outFile) {
	   new File(outFile).write( writer.toString() );
	 }	 
  }
  
  static def loadOldDataObjects(xmlFile) {
	  def tableDump = new XmlParser().parse(xmlFile);
	  def voList = [];
	  for(rec in tableDump.record) {
		  def vo = [:];
		  for(col in rec) {			  
			  // println "name=${col.'@name'}  value=${col.'@value'}";
			  vo[col.'@name'] = col.'@value';
		  }
		  voList << vo;
	  }
	  println "# recs: ${voList.size()}"
	  voList.each { println it }
	  return voList;
  }
  
  
  static void importCorrectedDataObjects(doList) {
	  def db = getDb();
	  DataObjectDAO dao = new DataObjectDAO(db: db);
	  DataObjectTypeDAO dotDAO = new DataObjectTypeDAO(db:db);
	  def dotList = dotDAO.find();
	  def dotMap = [:];
	  dotList.each { dotMap[ it.objecttype ] = it; }
	  doList.each { dov ->
		  def dot = dotMap[ dov.objecttype ];
		  dov.remove('objecttype');
		  dov['objecttypeid'] = dot.uniqueid;
		  println dov;
		  dao.create(dov);
	  }
  }
  
  static void main(args) {
     // exportOldDataObjects("/tmp/old_dataobjects.xml");
     
     def oldDOList = loadOldDataObjects("/tmp/old_dataobjects.xml");
     importCorrectedDataObjects(oldDOList);
  }

}