#!/usr/bin/env groovy
/**
  @author I. Burak Ozyurt
  @version $Id: run.groovy,v 1.3 2008/09/04 00:35:26 bozyurt Exp $
*/

def loader = this.class.classLoader.rootLoader;
//loader.URLs.each { println it }

def env = System.getenv();
if (env['CLINICAL_HOME'] == null) {
   println "You need to set CLINICAL_HOME environment variable!"
   System.exit(1);
}
def rootDir =  env['CLINICAL_HOME'];
def libDir = new File(rootDir,"lib");
libDir.eachFileMatch(~/.*\.jar$/) {
    if (!(it.name =~ /^bootstrap/))
      loader.addURL(it.toURL())  
}
loader.addURL( new File(rootDir,"conf").toURL() );
loader.addURL( new File(rootDir,"clinical_core.jar").toURL() );

if (args.length >= 1) {
   def f = new File(args[0]);
   if (!f.exists()) {
      f = new File(System.getProperty('user.dir'), args[0]);
   }
   def scriptArgs = [];
   if (args.length > 1) 
      scriptArgs = args[1..-1];
   Binding binding = new Binding();
   binding.setVariable("args",scriptArgs);
   
   GroovyShell shell = new GroovyShell(loader,binding);
   shell.evaluate(f.text);
}

