package clinical.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: DBChange.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class DBChange implements Serializable {
	private static final long serialVersionUID = 1L;
	protected String siteID;
	protected List<TableChange> changes = new ArrayList<TableChange>(2);

	public DBChange(String siteID) {
		super();
		this.siteID = siteID;
	}

	public void add(TableChange tc) {
		changes.add(tc);
	}

	public String getSiteID() {
		return siteID;
	}

	public List<TableChange> getChanges() {
		return changes;
	}

	public JSONObject toJSON() throws JSONException {
		JSONObject js = new JSONObject();
		js.put("site", siteID);
		JSONArray jsArr = new JSONArray();
		for (TableChange tc : changes) {
			jsArr.put(tc.toJSON());
		}
		js.put("changes", jsArr);
		return js;
	}

	public static DBChange fromJSON(JSONObject js) throws JSONException {
		String siteID = js.getString("site");
		DBChange dbc = new DBChange(siteID);

		JSONArray jsArr = js.getJSONArray("changes");
		if (jsArr != null) {
			for (int i = 0; i < jsArr.length(); i++) {
                 JSONObject o = jsArr.getJSONObject(i);
                 dbc.add( TableChange.fromJSON(o) );
			}
		}
		return dbc;
	}

}
