package clinical.comm;

import org.jdom.Element;

/**
 *
 * Represents a simple Java data type like Integer, String, Date, Float, Boolean etc
 * @author I. Burak Ozyurt
 * @version $Id: SimpleDataType.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class SimpleDataType implements IXMLSerializer {
  protected String className;
  protected String varName;
  protected String value;


  public SimpleDataType() {}

  public SimpleDataType(String className, String varName, String value) {
    this.className = className;
    this.varName = varName;
    this.value = value;
  }



//---------------------- setters --------------
  public void setClassName(String newClassName) { this.className = newClassName; }
  public void setVarName(String newVarName) { this.varName = newVarName; }
  public void setValue(String newValue) { this.value = newValue; }
//---------------------- getters --------------
  public String getClassName() { return this.className; }
  public String getVarName() { return this.varName; }
  public String getValue() { return this.value; }


  public Element toXML() {
      Element e = new Element("simple-var");
      e.setAttribute("type", className);
      e.setAttribute("name", varName);
      e.setAttribute("value", value);
      return e;
    }

    public void initializeFromXML(Element e) {
       this.className = e.getAttributeValue("type");
       this.varName = e.getAttributeValue("name");
       this.value = e.getAttributeValue("value");
    }

}

