package clinical.comm;

import java.util.HashMap;
import java.util.Map;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: SimpleRequestHandler.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class SimpleRequestHandler {
	protected Map<String, IRequestProcessor> registeredHandlersMap = new HashMap<String, IRequestProcessor>();

	public SimpleRequestHandler() {
	}

	public void registerHandler(String action,
			IRequestProcessor requestProcessor) {
		registeredHandlersMap.put(action, requestProcessor);
	}

	public Response handleRequest(Request req) throws XMLMessagingException {
		IRequestProcessor rp = registeredHandlersMap
				.get(req.getAction());
		if (rp == null)
			throw new XMLMessagingException(
					"No registered request handler for action "
							+ req.getAction());

		return rp.execute(req.getAction(), req);
	}

}
