package clinical.server.dao.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.Analysiscomponent;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class AnalysiscomponentDAO implements
		clinical.server.dao.AnalysiscomponentDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public AnalysiscomponentDAO() {}

	public void insert(Connection con, Analysiscomponent bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO NC_ANALYSISCOMPONENT ");
			buf
					.append(" (UNIQUEID,TABLEID,OWNER,MODTIME,MODUSER,ANALYSISID,COMPONENTID,TRANSFORMATIONID,NODELEVEL,PARENTCOMPONENTID) ");
			buf.append("VALUES ");

			buf.append('(');
			for (int i = 0; i < 10; ++i) {
				buf.append('?');
				if (i < 9)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, (java.math.BigDecimal) bean.getUniqueid(),
					Types.NUMERIC);
			ps.setObject(2, (java.math.BigDecimal) bean.getTableid(),
					Types.NUMERIC);
			ps.setObject(3, (java.math.BigDecimal) bean.getOwner(), Types.NUMERIC);
			ps.setTimestamp(4, bean.getModtime() == null ? null
					: new java.sql.Timestamp(bean.getModtime().getTime()));
			ps.setObject(5, (java.math.BigDecimal) bean.getModuser(),
					Types.NUMERIC);
			ps.setObject(6, (java.math.BigDecimal) bean.getAnalysisid(),
					Types.NUMERIC);
			ps.setObject(7, (java.math.BigDecimal) bean.getComponentid(),
					Types.NUMERIC);
			ps.setObject(8, (java.math.BigDecimal) bean.getTransformationid(),
					Types.NUMERIC);
			ps.setObject(9, (java.math.BigDecimal) bean.getNodelevel(),
					Types.NUMERIC);
			ps.setObject(10, (java.math.BigDecimal) bean.getParentcomponentid(),
					Types.NUMERIC);
			ps.executeUpdate();

		} finally {
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}

	protected String prepareColList(Analysiscomponent bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("UNIQUEID");
		buf.append(',');
		buf.append("TABLEID");
		buf.append(',');
		buf.append("OWNER");
		buf.append(',');
		buf.append("MODTIME");
		buf.append(',');
		buf.append("MODUSER");
		buf.append(',');
		buf.append("ANALYSISID");
		buf.append(',');
		buf.append("COMPONENTID");
		buf.append(',');
		buf.append("TRANSFORMATIONID");
		buf.append(',');
		buf.append("NODELEVEL");
		buf.append(',');
		buf.append("PARENTCOMPONENTID");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Analysiscomponent bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");

		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("UNIQUEID=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TABLEID=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("OWNER=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODTIME=?");
			qi.values.add(new java.sql.Timestamp(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODUSER=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getAnalysisid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ANALYSISID=?");
			qi.values.add(bean.getAnalysisid());
			valueSet = true;
		}
		if (bean.getComponentid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("COMPONENTID=?");
			qi.values.add(bean.getComponentid());
			valueSet = true;
		}
		if (bean.getTransformationid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TRANSFORMATIONID=?");
			qi.values.add(bean.getTransformationid());
			valueSet = true;
		}
		if (bean.getNodelevel() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("NODELEVEL=?");
			qi.values.add(bean.getNodelevel());
			valueSet = true;
		}
		if (bean.getParentcomponentid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("PARENTCOMPONENTID=?");
			qi.values.add(bean.getParentcomponentid());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Analysiscomponent bean,
			Analysiscomponent criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE NC_ANALYSISCOMPONENT SET ");

		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("UNIQUEID=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getTableid() != null || bean.isNull("tableid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("TABLEID=? ");
			uqi.setValues.add(bean.getTableid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tableid"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("OWNER=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODTIME=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime().getTime()));
			uqi.sqlTypes.add(new Integer(Types.DATE));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODUSER=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (bean.getAnalysisid() != null || bean.isNull("analysisid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ANALYSISID=? ");
			uqi.setValues.add(bean.getAnalysisid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("analysisid"), uqi);
			valueSet = true;
		}
		if (bean.getComponentid() != null || bean.isNull("componentid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("COMPONENTID=? ");
			uqi.setValues.add(bean.getComponentid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("componentid"), uqi);
			valueSet = true;
		}
		if (bean.getTransformationid() != null || bean.isNull("transformationid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("TRANSFORMATIONID=? ");
			uqi.setValues.add(bean.getTransformationid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("transformationid"), uqi);
			valueSet = true;
		}
		if (bean.getNodelevel() != null || bean.isNull("nodelevel")) {
			if (valueSet)
				buf.append(", ");
			buf.append("NODELEVEL=? ");
			uqi.setValues.add(bean.getNodelevel());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("nodelevel"), uqi);
			valueSet = true;
		}
		if (bean.getParentcomponentid() != null
				|| bean.isNull("parentcomponentid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("PARENTCOMPONENTID=? ");
			uqi.setValues.add(bean.getParentcomponentid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("parentcomponentid"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	public Analysiscomponent createObject(ResultSet rs) throws SQLException {
		Analysiscomponent obj = new Analysiscomponent();
		obj.setUniqueid((java.math.BigDecimal) rs.getObject(1));
		obj.setTableid((java.math.BigDecimal) rs.getObject(2));
		obj.setOwner((java.math.BigDecimal) rs.getObject(3));
		if (rs.getTimestamp(4) != null) {
			obj.setModtime(new java.util.Date(rs.getTimestamp(4).getTime()));
		}
		obj.setModuser((java.math.BigDecimal) rs.getObject(5));
		obj.setAnalysisid((java.math.BigDecimal) rs.getObject(6));
		obj.setComponentid((java.math.BigDecimal) rs.getObject(7));
		obj.setTransformationid((java.math.BigDecimal) rs.getObject(8));
		obj.setNodelevel((java.math.BigDecimal) rs.getObject(9));
		obj.setParentcomponentid((java.math.BigDecimal) rs.getObject(10));
		return obj;
	}

	public List<Analysiscomponent> find(Connection con,
			Analysiscomponent criteria) throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Analysiscomponent> results = new LinkedList<Analysiscomponent>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM NC_ANALYSISCOMPONENT ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Analysiscomponent item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Analysiscomponent bean,
			Analysiscomponent criteria) throws Exception {

		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Analysiscomponent criteria)
			throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM NC_ANALYSISCOMPONENT ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
