package clinical.server.dao.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.ConfParamsGroup;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class ConfParamsGroupDAO implements
		clinical.server.dao.ConfParamsGroupDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public ConfParamsGroupDAO() {}

	public void insert(Connection con, ConfParamsGroup bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO NC_CONF_PARAMS_GROUP ");
			buf
					.append(" (UNIQUE_ID,GROUP_NAME,DESCRIPTION,OWNER,MOD_TIME,MOD_USER) ");
			buf.append("VALUES ");

			buf.append('(');
			for (int i = 0; i < 6; ++i) {
				buf.append('?');
				if (i < 5)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, (java.math.BigDecimal) bean.getUniqueId(),
					Types.NUMERIC);
			ps.setObject(2, (String) bean.getGroupName(), Types.VARCHAR);
			ps.setObject(3, (String) bean.getDescription(), Types.VARCHAR);
			ps.setObject(4, (java.math.BigDecimal) bean.getOwner(), Types.NUMERIC);
			ps.setTimestamp(5, bean.getModTime() == null ? null
					: new java.sql.Timestamp(bean.getModTime().getTime()));
			ps.setObject(6, (java.math.BigDecimal) bean.getModUser(),
					Types.NUMERIC);
			ps.executeUpdate();

		} finally {
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}

	protected String prepareColList(ConfParamsGroup bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("UNIQUE_ID");
		buf.append(',');
		buf.append("GROUP_NAME");
		buf.append(',');
		buf.append("DESCRIPTION");
		buf.append(',');
		buf.append("OWNER");
		buf.append(',');
		buf.append("MOD_TIME");
		buf.append(',');
		buf.append("MOD_USER");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(ConfParamsGroup bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");

		if (bean.getUniqueId() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("UNIQUE_ID=?");
			qi.values.add(bean.getUniqueId());
			valueSet = true;
		}
		if (bean.getGroupName() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("GROUP_NAME=?");
			qi.values.add(bean.getGroupName());
			valueSet = true;
		}
		if (bean.getDescription() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("DESCRIPTION=?");
			qi.values.add(bean.getDescription());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("OWNER=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModTime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MOD_TIME=?");
			qi.values.add(new java.sql.Timestamp(bean.getModTime().getTime()));
			valueSet = true;
		}
		if (bean.getModUser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MOD_USER=?");
			qi.values.add(bean.getModUser());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(ConfParamsGroup bean,
			ConfParamsGroup criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE NC_CONF_PARAMS_GROUP SET ");

		if (bean.getUniqueId() != null || bean.isNull("uniqueId")) {
			if (valueSet)
				buf.append(", ");
			buf.append("UNIQUE_ID=? ");
			uqi.setValues.add(bean.getUniqueId());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueId"), uqi);
			valueSet = true;
		}
		if (bean.getGroupName() != null || bean.isNull("groupName")) {
			if (valueSet)
				buf.append(", ");
			buf.append("GROUP_NAME=? ");
			uqi.setValues.add(bean.getGroupName());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("groupName"), uqi);
			valueSet = true;
		}
		if (bean.getDescription() != null || bean.isNull("description")) {
			if (valueSet)
				buf.append(", ");
			buf.append("DESCRIPTION=? ");
			uqi.setValues.add(bean.getDescription());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("description"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("OWNER=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModTime() != null || bean.isNull("modTime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MOD_TIME=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModTime().getTime()));
			uqi.sqlTypes.add(new Integer(Types.DATE));
			prepareNullSetListValue(bean.isNull("modTime"), uqi);
			valueSet = true;
		}
		if (bean.getModUser() != null || bean.isNull("modUser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MOD_USER=? ");
			uqi.setValues.add(bean.getModUser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("modUser"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	public ConfParamsGroup createObject(ResultSet rs) throws SQLException {
		ConfParamsGroup obj = new ConfParamsGroup();
		obj.setUniqueId((java.math.BigDecimal) rs.getObject(1));
		obj.setGroupName((String) rs.getObject(2));
		obj.setDescription((String) rs.getObject(3));
		obj.setOwner((java.math.BigDecimal) rs.getObject(4));
		if (rs.getTimestamp(5) != null) {
			obj.setModTime(new java.util.Date(rs.getTimestamp(5).getTime()));
		}
		obj.setModUser((java.math.BigDecimal) rs.getObject(6));
		return obj;
	}

	public List<ConfParamsGroup> find(Connection con, ConfParamsGroup criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<ConfParamsGroup> results = new LinkedList<ConfParamsGroup>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM NC_CONF_PARAMS_GROUP ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				ConfParamsGroup item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, ConfParamsGroup bean,
			ConfParamsGroup criteria) throws Exception {

		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, ConfParamsGroup criteria)
			throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM NC_CONF_PARAMS_GROUP ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
