package clinical.server.dao.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.Publication;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class PublicationDAO implements clinical.server.dao.PublicationDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public PublicationDAO() {
	}

	public void insert(Connection con, Publication bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO nc_publication VALUES ");
			buf.append('(');
			for (int i = 0; i < 5; ++i) {
				buf.append('?');
				if (i < 4)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, bean.getUniqueid(), Types.NUMERIC);

			ps.setObject(2, bean.getReference(), Types.VARCHAR);

			ps.setObject(3, bean.getRefIdentifier(), Types.VARCHAR);

			ps.setObject(4, bean.getRefIdType(), Types.VARCHAR);

			ps.setObject(5, bean.getUdId(), Types.NUMERIC);

			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	protected String prepareColList(Publication bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("uniqueid");
		buf.append(',');
		buf.append("reference");
		buf.append(',');
		buf.append("ref_identifier");
		buf.append(',');
		buf.append("ref_id_type");
		buf.append(',');
		buf.append("ud_id");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Publication bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("uniqueid=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getReference() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("reference=?");
			qi.values.add(bean.getReference());
			valueSet = true;
		}
		if (bean.getRefIdentifier() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ref_identifier=?");
			qi.values.add(bean.getRefIdentifier());
			valueSet = true;
		}
		if (bean.getRefIdType() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ref_id_type=?");
			qi.values.add(bean.getRefIdType());
			valueSet = true;
		}
		if (bean.getUdId() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ud_id=?");
			qi.values.add(bean.getUdId());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Publication bean,
			Publication criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE nc_publication SET ");
		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("uniqueid=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getReference() != null || bean.isNull("reference")) {
			if (valueSet)
				buf.append(", ");
			buf.append("reference=? ");
			uqi.setValues.add(bean.getReference());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("reference"), uqi);
			valueSet = true;
		}
		if (bean.getRefIdentifier() != null || bean.isNull("refIdentifier")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ref_identifier=? ");
			uqi.setValues.add(bean.getRefIdentifier());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("refIdentifier"), uqi);
			valueSet = true;
		}
		if (bean.getRefIdType() != null || bean.isNull("refIdType")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ref_id_type=? ");
			uqi.setValues.add(bean.getRefIdType());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("refIdType"), uqi);
			valueSet = true;
		}
		if (bean.getUdId() != null || bean.isNull("udId")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ud_id=? ");
			uqi.setValues.add(bean.getUdId());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("udId"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	public Publication createObject(ResultSet rs) throws SQLException {
		Publication obj = new Publication();
		obj.setUniqueid((rs.getObject(1) != null) ? new java.math.BigDecimal(rs
				.getObject(1).toString()) : null);
		obj.setReference((String) rs.getObject(2));
		obj.setRefIdentifier((String) rs.getObject(3));
		obj.setRefIdType((String) rs.getObject(4));
		obj.setUdId((rs.getObject(5) != null) ? new java.math.BigDecimal(rs
				.getObject(5).toString()) : null);
		return obj;
	}

	public List<Publication> find(Connection con, Publication criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Publication> results = new LinkedList<Publication>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM nc_publication ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Publication item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Publication bean, Publication criteria)
			throws Exception {
		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Publication criteria) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM nc_publication ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
