package clinical.server.dao.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.StoredJobResultGroup;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class StoredJobResultGroupDAO implements
		clinical.server.dao.StoredJobResultGroupDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public StoredJobResultGroupDAO() {
	}

	public void insert(Connection con, StoredJobResultGroup bean)
			throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO nc_stored_job_result_group VALUES ");
			buf.append('(');
			for (int i = 0; i < 8; ++i) {
				buf.append('?');
				if (i < 7)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, bean.getUniqueid(), Types.NUMERIC);

			ps.setObject(2, bean.getJobGroupId(), Types.NUMERIC);

			ps.setObject(3, bean.getJobProvenanceId(), Types.NUMERIC);

			ps.setObject(4, bean.getJobUniqueid(), Types.NUMERIC);

			ps.setObject(5, bean.getExpId(), Types.NUMERIC);

			ps.setObject(6, bean.getSubjectid(), Types.VARCHAR);

			ps.setObject(7, bean.getVisitId(), Types.NUMERIC);

			ps.setObject(8,
					bean.getModtime() == null ? (java.sql.Timestamp) null
							: new java.sql.Timestamp(bean.getModtime()
									.getTime()));

			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	protected String prepareColList(StoredJobResultGroup bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("uniqueid");
		buf.append(',');
		buf.append("job_group_id");
		buf.append(',');
		buf.append("job_provenance_id");
		buf.append(',');
		buf.append("job_uniqueid");
		buf.append(',');
		buf.append("exp_id");
		buf.append(',');
		buf.append("subjectid");
		buf.append(',');
		buf.append("visit_id");
		buf.append(',');
		buf.append("modtime");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(StoredJobResultGroup bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("uniqueid=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getJobGroupId() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("job_group_id=?");
			qi.values.add(bean.getJobGroupId());
			valueSet = true;
		}
		if (bean.getJobProvenanceId() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("job_provenance_id=?");
			qi.values.add(bean.getJobProvenanceId());
			valueSet = true;
		}
		if (bean.getJobUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("job_uniqueid=?");
			qi.values.add(bean.getJobUniqueid());
			valueSet = true;
		}
		if (bean.getExpId() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("exp_id=?");
			qi.values.add(bean.getExpId());
			valueSet = true;
		}
		if (bean.getSubjectid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("subjectid=?");
			qi.values.add(bean.getSubjectid());
			valueSet = true;
		}
		if (bean.getVisitId() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("visit_id=?");
			qi.values.add(bean.getVisitId());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("modtime=?");
			qi.values.add(new java.sql.Date(bean.getModtime().getTime()));
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(StoredJobResultGroup bean,
			StoredJobResultGroup criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE nc_stored_job_result_group SET ");
		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("uniqueid=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getJobGroupId() != null || bean.isNull("jobGroupId")) {
			if (valueSet)
				buf.append(", ");
			buf.append("job_group_id=? ");
			uqi.setValues.add(bean.getJobGroupId());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("jobGroupId"), uqi);
			valueSet = true;
		}
		if (bean.getJobProvenanceId() != null || bean.isNull("jobProvenanceId")) {
			if (valueSet)
				buf.append(", ");
			buf.append("job_provenance_id=? ");
			uqi.setValues.add(bean.getJobProvenanceId());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("jobProvenanceId"), uqi);
			valueSet = true;
		}
		if (bean.getJobUniqueid() != null || bean.isNull("jobUniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("job_uniqueid=? ");
			uqi.setValues.add(bean.getJobUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("jobUniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getExpId() != null || bean.isNull("expId")) {
			if (valueSet)
				buf.append(", ");
			buf.append("exp_id=? ");
			uqi.setValues.add(bean.getExpId());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("expId"), uqi);
			valueSet = true;
		}
		if (bean.getSubjectid() != null || bean.isNull("subjectid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("subjectid=? ");
			uqi.setValues.add(bean.getSubjectid());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("subjectid"), uqi);
			valueSet = true;
		}
		if (bean.getVisitId() != null || bean.isNull("visitId")) {
			if (valueSet)
				buf.append(", ");
			buf.append("visit_id=? ");
			uqi.setValues.add(bean.getVisitId());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("visitId"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("modtime=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime()
					.getTime()));
			uqi.sqlTypes.add(new Integer(Types.TIMESTAMP));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	public StoredJobResultGroup createObject(ResultSet rs) throws SQLException {
		StoredJobResultGroup obj = new StoredJobResultGroup();
		obj.setUniqueid((rs.getObject(1) != null) ? new java.math.BigDecimal(rs
				.getObject(1).toString()) : null);
		obj.setJobGroupId((rs.getObject(2) != null) ? new java.math.BigDecimal(
				rs.getObject(2).toString()) : null);
		obj.setJobProvenanceId((rs.getObject(3) != null) ? new java.math.BigDecimal(
				rs.getObject(3).toString()) : null);
		obj.setJobUniqueid((rs.getObject(4) != null) ? new java.math.BigDecimal(
				rs.getObject(4).toString()) : null);
		obj.setExpId((rs.getObject(5) != null) ? new java.math.BigDecimal(rs
				.getObject(5).toString()) : null);
		obj.setSubjectid((String) rs.getObject(6));
		obj.setVisitId((rs.getObject(7) != null) ? new java.math.BigDecimal(rs
				.getObject(7).toString()) : null);
		obj.setModtime((rs.getObject(8) != null) ? new java.util.Date(
				((java.sql.Timestamp) rs.getObject(8)).getTime()) : null);
		return obj;
	}

	public List<StoredJobResultGroup> find(Connection con,
			StoredJobResultGroup criteria) throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<StoredJobResultGroup> results = new LinkedList<StoredJobResultGroup>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM nc_stored_job_result_group ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				StoredJobResultGroup item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, StoredJobResultGroup bean,
			StoredJobResultGroup criteria) throws Exception {
		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, StoredJobResultGroup criteria)
			throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM nc_stored_job_result_group ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
