package clinical.server.dao.oracle;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.Transformationargument;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class TransformationargumentDAO implements
		clinical.server.dao.TransformationargumentDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public TransformationargumentDAO() {}

	public void insert(Connection con, Transformationargument bean)
			throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO NC_TRANSFORMATIONARGUMENT ");
			buf
					.append(" (UNIQUEID,TABLEID,OWNER,MODTIME,MODUSER,ARGNAME,TRANSFORMID,OPTIONAL,ISINPUTDATA,ISOUTPUTDATA,ARGUMENTTYPE,ARGUMENTDATATYPE) ");
			buf.append("VALUES ");

			buf.append('(');
			for (int i = 0; i < 12; ++i) {
				buf.append('?');
				if (i < 11)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, (java.math.BigDecimal) bean.getUniqueid(),
					Types.NUMERIC);
			ps.setObject(2, (java.math.BigDecimal) bean.getTableid(),
					Types.NUMERIC);
			ps.setObject(3, (java.math.BigDecimal) bean.getOwner(), Types.NUMERIC);
			ps.setTimestamp(4, bean.getModtime() == null ? null
					: new java.sql.Timestamp(bean.getModtime().getTime()));
			ps.setObject(5, (java.math.BigDecimal) bean.getModuser(),
					Types.NUMERIC);
			ps.setObject(6, (String) bean.getArgname(), Types.VARCHAR);
			ps.setObject(7, (java.math.BigDecimal) bean.getTransformid(),
					Types.NUMERIC);
			ps.setObject(8, boolean2Number((Boolean) bean.getOptional()),
					Types.NUMERIC);
			ps.setObject(9, boolean2Number((Boolean) bean.getIsinputdata()),
					Types.NUMERIC);
			ps.setObject(10, boolean2Number((Boolean) bean.getIsoutputdata()),
					Types.NUMERIC);
			ps.setObject(11, (String) bean.getArgumenttype(), Types.VARCHAR);
			ps.setObject(12, (String) bean.getArgumentdatatype(), Types.VARCHAR);
			ps.executeUpdate();

		} finally {
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}

	protected String prepareColList(Transformationargument bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("UNIQUEID");
		buf.append(',');
		buf.append("TABLEID");
		buf.append(',');
		buf.append("OWNER");
		buf.append(',');
		buf.append("MODTIME");
		buf.append(',');
		buf.append("MODUSER");
		buf.append(',');
		buf.append("ARGNAME");
		buf.append(',');
		buf.append("TRANSFORMID");
		buf.append(',');
		buf.append("OPTIONAL");
		buf.append(',');
		buf.append("ISINPUTDATA");
		buf.append(',');
		buf.append("ISOUTPUTDATA");
		buf.append(',');
		buf.append("ARGUMENTTYPE");
		buf.append(',');
		buf.append("ARGUMENTDATATYPE");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Transformationargument bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");

		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("UNIQUEID=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TABLEID=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("OWNER=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODTIME=?");
			qi.values.add(new java.sql.Timestamp(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODUSER=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getArgname() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ARGNAME=?");
			qi.values.add(bean.getArgname());
			valueSet = true;
		}
		if (bean.getTransformid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TRANSFORMID=?");
			qi.values.add(bean.getTransformid());
			valueSet = true;
		}
		if (bean.getOptional() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("OPTIONAL=?");
			qi.values.add(boolean2Number((Boolean) bean.getOptional()));
			valueSet = true;
		}
		if (bean.getIsinputdata() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ISINPUTDATA=?");
			qi.values.add(boolean2Number((Boolean) bean.getIsinputdata()));
			valueSet = true;
		}
		if (bean.getIsoutputdata() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ISOUTPUTDATA=?");
			qi.values.add(boolean2Number((Boolean) bean.getIsoutputdata()));
			valueSet = true;
		}
		if (bean.getArgumenttype() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ARGUMENTTYPE=?");
			qi.values.add(bean.getArgumenttype());
			valueSet = true;
		}
		if (bean.getArgumentdatatype() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ARGUMENTDATATYPE=?");
			qi.values.add(bean.getArgumentdatatype());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Transformationargument bean,
			Transformationargument criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE NC_TRANSFORMATIONARGUMENT SET ");

		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("UNIQUEID=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getTableid() != null || bean.isNull("tableid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("TABLEID=? ");
			uqi.setValues.add(bean.getTableid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tableid"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("OWNER=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODTIME=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime().getTime()));
			uqi.sqlTypes.add(new Integer(Types.DATE));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODUSER=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (bean.getArgname() != null || bean.isNull("argname")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ARGNAME=? ");
			uqi.setValues.add(bean.getArgname());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("argname"), uqi);
			valueSet = true;
		}
		if (bean.getTransformid() != null || bean.isNull("transformid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("TRANSFORMID=? ");
			uqi.setValues.add(bean.getTransformid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("transformid"), uqi);
			valueSet = true;
		}
		if (bean.getOptional() != null || bean.isNull("optional")) {
			if (valueSet)
				buf.append(", ");
			buf.append("OPTIONAL=? ");
			uqi.setValues.add(boolean2Number((Boolean) bean.getOptional()));
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("optional"), uqi);
			valueSet = true;
		}
		if (bean.getIsinputdata() != null || bean.isNull("isinputdata")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ISINPUTDATA=? ");
			uqi.setValues.add(boolean2Number((Boolean) bean.getIsinputdata()));
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("isinputdata"), uqi);
			valueSet = true;
		}
		if (bean.getIsoutputdata() != null || bean.isNull("isoutputdata")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ISOUTPUTDATA=? ");
			uqi.setValues.add(boolean2Number((Boolean) bean.getIsoutputdata()));
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("isoutputdata"), uqi);
			valueSet = true;
		}
		if (bean.getArgumenttype() != null || bean.isNull("argumenttype")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ARGUMENTTYPE=? ");
			uqi.setValues.add(bean.getArgumenttype());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("argumenttype"), uqi);
			valueSet = true;
		}
		if (bean.getArgumentdatatype() != null || bean.isNull("argumentdatatype")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ARGUMENTDATATYPE=? ");
			uqi.setValues.add(bean.getArgumentdatatype());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("argumentdatatype"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	protected Boolean convert2Boolean(Object columnValue) {
		if (columnValue == null)
			return null;
		return ((java.math.BigDecimal) columnValue).intValue() > 0 ? new Boolean(
				true) : new Boolean(false);
	}

	protected BigDecimal boolean2Number(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? new java.math.BigDecimal("1")
				: new java.math.BigDecimal("0");
	}

	protected String boolean2YN(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? "Y" : "N";
	}

	public Transformationargument createObject(ResultSet rs) throws SQLException {
		Transformationargument obj = new Transformationargument();
		obj.setUniqueid((java.math.BigDecimal) rs.getObject(1));
		obj.setTableid((java.math.BigDecimal) rs.getObject(2));
		obj.setOwner((java.math.BigDecimal) rs.getObject(3));
		if (rs.getTimestamp(4) != null) {
			obj.setModtime(new java.util.Date(rs.getTimestamp(4).getTime()));
		}
		obj.setModuser((java.math.BigDecimal) rs.getObject(5));
		obj.setArgname((String) rs.getObject(6));
		obj.setTransformid((java.math.BigDecimal) rs.getObject(7));
		obj.setOptional(convert2Boolean(rs.getObject(8)));
		obj.setIsinputdata(convert2Boolean(rs.getObject(9)));
		obj.setIsoutputdata(convert2Boolean(rs.getObject(10)));
		obj.setArgumenttype((String) rs.getObject(11));
		obj.setArgumentdatatype((String) rs.getObject(12));
		return obj;
	}

	public List<Transformationargument> find(Connection con,
			Transformationargument criteria) throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Transformationargument> results = new LinkedList<Transformationargument>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM NC_TRANSFORMATIONARGUMENT ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Transformationargument item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Transformationargument bean,
			Transformationargument criteria) throws Exception {

		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Transformationargument criteria)
			throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM NC_TRANSFORMATIONARGUMENT ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
