package clinical.server.dao.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.utils.OracleUtils;
import clinical.server.vo.Tupleinteger;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class TupleintegerDAO implements clinical.server.dao.TupleintegerDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public TupleintegerDAO() {}

	public void insert(Connection con, Tupleinteger bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO NC_TUPLEINTEGER ");
			buf
					.append(" (TABLEID,UNIQUEID,OWNER,MODTIME,MODUSER,EXTENDEDTUPLEID,COLUMNNAME,COLUMNTYPE,STOREDTUPLEID,TEXTVALUE,COMMENTS,DATAVALUE) ");
			buf.append("VALUES ");

			buf.append('(');
			for (int i = 0; i < 12; ++i) {
				buf.append('?');
				if (i < 11)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, (java.math.BigDecimal) bean.getTableid(),
					Types.NUMERIC);
			ps.setObject(2, (java.math.BigDecimal) bean.getUniqueid(),
					Types.NUMERIC);
			ps.setObject(3, (java.math.BigDecimal) bean.getOwner(), Types.NUMERIC);
			ps.setTimestamp(4, bean.getModtime() == null ? null
					: new java.sql.Timestamp(bean.getModtime().getTime()));
			ps.setObject(5, (java.math.BigDecimal) bean.getModuser(),
					Types.NUMERIC);
			ps.setObject(6, (java.math.BigDecimal) bean.getExtendedtupleid(),
					Types.NUMERIC);
			ps.setObject(7, (String) bean.getColumnname(), Types.VARCHAR);
			ps.setObject(8, (String) bean.getColumntype(), Types.VARCHAR);
			ps.setObject(9, (java.math.BigDecimal) bean.getStoredtupleid(),
					Types.NUMERIC);
			ps.setObject(10, (String) bean.getTextvalue(), Types.VARCHAR);
			ps.setObject(11, OracleUtils.getCLOB(con, bean.getComments()),
					Types.CLOB);
			ps.setObject(12, (java.math.BigDecimal) bean.getDatavalue(),
					Types.NUMERIC);
			ps.executeUpdate();

		} finally {
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}

	protected String prepareColList(Tupleinteger bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("TABLEID");
		buf.append(',');
		buf.append("UNIQUEID");
		buf.append(',');
		buf.append("OWNER");
		buf.append(',');
		buf.append("MODTIME");
		buf.append(',');
		buf.append("MODUSER");
		buf.append(',');
		buf.append("EXTENDEDTUPLEID");
		buf.append(',');
		buf.append("COLUMNNAME");
		buf.append(',');
		buf.append("COLUMNTYPE");
		buf.append(',');
		buf.append("STOREDTUPLEID");
		buf.append(',');
		buf.append("TEXTVALUE");
		buf.append(',');
		buf.append("COMMENTS");
		buf.append(',');
		buf.append("DATAVALUE");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Tupleinteger bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");

		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TABLEID=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("UNIQUEID=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("OWNER=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODTIME=?");
			qi.values.add(new java.sql.Timestamp(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODUSER=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getExtendedtupleid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("EXTENDEDTUPLEID=?");
			qi.values.add(bean.getExtendedtupleid());
			valueSet = true;
		}
		if (bean.getColumnname() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("COLUMNNAME=?");
			qi.values.add(bean.getColumnname());
			valueSet = true;
		}
		if (bean.getColumntype() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("COLUMNTYPE=?");
			qi.values.add(bean.getColumntype());
			valueSet = true;
		}
		if (bean.getStoredtupleid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("STOREDTUPLEID=?");
			qi.values.add(bean.getStoredtupleid());
			valueSet = true;
		}
		if (bean.getTextvalue() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TEXTVALUE=?");
			qi.values.add(bean.getTextvalue());
			valueSet = true;
		}
		if (bean.getComments() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("COMMENTS=?");
			qi.values.add(bean.getComments());
			valueSet = true;
		}
		if (bean.getDatavalue() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("DATAVALUE=?");
			qi.values.add(bean.getDatavalue());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Tupleinteger bean,
			Tupleinteger criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE NC_TUPLEINTEGER SET ");

		if (bean.getTableid() != null || bean.isNull("tableid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("TABLEID=? ");
			uqi.setValues.add(bean.getTableid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tableid"), uqi);
			valueSet = true;
		}
		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("UNIQUEID=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("OWNER=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODTIME=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime().getTime()));
			uqi.sqlTypes.add(new Integer(Types.DATE));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODUSER=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (bean.getExtendedtupleid() != null || bean.isNull("extendedtupleid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("EXTENDEDTUPLEID=? ");
			uqi.setValues.add(bean.getExtendedtupleid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("extendedtupleid"), uqi);
			valueSet = true;
		}
		if (bean.getColumnname() != null || bean.isNull("columnname")) {
			if (valueSet)
				buf.append(", ");
			buf.append("COLUMNNAME=? ");
			uqi.setValues.add(bean.getColumnname());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("columnname"), uqi);
			valueSet = true;
		}
		if (bean.getColumntype() != null || bean.isNull("columntype")) {
			if (valueSet)
				buf.append(", ");
			buf.append("COLUMNTYPE=? ");
			uqi.setValues.add(bean.getColumntype());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("columntype"), uqi);
			valueSet = true;
		}
		if (bean.getStoredtupleid() != null || bean.isNull("storedtupleid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("STOREDTUPLEID=? ");
			uqi.setValues.add(bean.getStoredtupleid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("storedtupleid"), uqi);
			valueSet = true;
		}
		if (bean.getTextvalue() != null || bean.isNull("textvalue")) {
			if (valueSet)
				buf.append(", ");
			buf.append("TEXTVALUE=? ");
			uqi.setValues.add(bean.getTextvalue());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("textvalue"), uqi);
			valueSet = true;
		}
		if (bean.getComments() != null || bean.isNull("comments")) {
			if (valueSet)
				buf.append(", ");
			buf.append("COMMENTS=? ");
			uqi.setValues.add(bean.getComments());
			uqi.sqlTypes.add(new Integer(Types.CLOB));
			prepareNullSetListValue(bean.isNull("comments"), uqi);
			valueSet = true;
		}
		if (bean.getDatavalue() != null || bean.isNull("datavalue")) {
			if (valueSet)
				buf.append(", ");
			buf.append("DATAVALUE=? ");
			uqi.setValues.add(bean.getDatavalue());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("datavalue"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	public Tupleinteger createObject(ResultSet rs) throws SQLException {
		Tupleinteger obj = new Tupleinteger();
		obj.setTableid((java.math.BigDecimal) rs.getObject(1));
		obj.setUniqueid((java.math.BigDecimal) rs.getObject(2));
		obj.setOwner((java.math.BigDecimal) rs.getObject(3));
		if (rs.getTimestamp(4) != null) {
			obj.setModtime(new java.util.Date(rs.getTimestamp(4).getTime()));
		}
		obj.setModuser((java.math.BigDecimal) rs.getObject(5));
		obj.setExtendedtupleid((java.math.BigDecimal) rs.getObject(6));
		obj.setColumnname((String) rs.getObject(7));
		obj.setColumntype((String) rs.getObject(8));
		obj.setStoredtupleid((java.math.BigDecimal) rs.getObject(9));
		obj.setTextvalue((String) rs.getObject(10));
		obj.setComments(OracleUtils.readCLOB((oracle.sql.CLOB) rs.getObject(11)));
		obj.setDatavalue((java.math.BigDecimal) rs.getObject(12));
		return obj;
	}

	public List<Tupleinteger> find(Connection con, Tupleinteger criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Tupleinteger> results = new LinkedList<Tupleinteger>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM NC_TUPLEINTEGER ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Tupleinteger item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Tupleinteger bean, Tupleinteger criteria)
			throws Exception {

		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Tupleinteger criteria) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM NC_TUPLEINTEGER ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
