package clinical.server.dao.postgres;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.Analysisresult;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class AnalysisresultDAO implements clinical.server.dao.AnalysisresultDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public AnalysisresultDAO() {
	}

	public void insert(Connection con, Analysisresult bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO nc_analysisresult VALUES ");
			buf.append('(');
			for (int i = 0; i < 20; ++i) {
				buf.append('?');
				if (i < 19)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, bean.getUniqueid(), Types.NUMERIC);

			ps.setObject(2, bean.getTableid(), Types.NUMERIC);

			ps.setObject(3, bean.getSegmentid(), Types.NUMERIC);

			ps.setObject(4, bean.getComponentid(), Types.NUMERIC);

			ps.setObject(5, bean.getExperimentid(), Types.NUMERIC);

			ps.setObject(6, bean.getSubjectid(), Types.VARCHAR);

			ps.setObject(7, bean.getExecutedtransformid(), Types.NUMERIC);

			ps.setObject(8, bean.getAnalysisid(), Types.NUMERIC);

			ps.setObject(9, bean.getAnalysisname(), Types.VARCHAR);

			ps.setObject(10, bean.getDescription(), Types.VARCHAR);

			ps.setObject(11, bean.getOwner(), Types.NUMERIC);

			ps.setObject(12,
					bean.getModtime() == null ? (java.sql.Timestamp) null
							: new java.sql.Timestamp(bean.getModtime()
									.getTime()));

			ps.setObject(13, bean.getModuser(), Types.NUMERIC);

			ps.setObject(14, bean.getOntologysource(), Types.VARCHAR);

			ps.setObject(15, bean.getConceptid(), Types.VARCHAR);

			ps.setObject(16, bean.getIsbad());

			ps.setObject(17, bean.getGroupname(), Types.VARCHAR);

			ps.setObject(18, bean.getGrouplongname(), Types.VARCHAR);

			ps.setObject(19, bean.getGroupontologysource(), Types.VARCHAR);

			ps.setObject(20, bean.getGroupconceptid(), Types.VARCHAR);

			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	protected String prepareColList(Analysisresult bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("uniqueid");
		buf.append(',');
		buf.append("tableid");
		buf.append(',');
		buf.append("segmentid");
		buf.append(',');
		buf.append("componentid");
		buf.append(',');
		buf.append("experimentid");
		buf.append(',');
		buf.append("subjectid");
		buf.append(',');
		buf.append("executedtransformid");
		buf.append(',');
		buf.append("analysisid");
		buf.append(',');
		buf.append("analysisname");
		buf.append(',');
		buf.append("description");
		buf.append(',');
		buf.append("owner");
		buf.append(',');
		buf.append("modtime");
		buf.append(',');
		buf.append("moduser");
		buf.append(',');
		buf.append("ontologysource");
		buf.append(',');
		buf.append("conceptid");
		buf.append(',');
		buf.append("isbad");
		buf.append(',');
		buf.append("groupname");
		buf.append(',');
		buf.append("grouplongname");
		buf.append(',');
		buf.append("groupontologysource");
		buf.append(',');
		buf.append("groupconceptid");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Analysisresult bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("uniqueid=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("tableid=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getSegmentid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("segmentid=?");
			qi.values.add(bean.getSegmentid());
			valueSet = true;
		}
		if (bean.getComponentid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("componentid=?");
			qi.values.add(bean.getComponentid());
			valueSet = true;
		}
		if (bean.getExperimentid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("experimentid=?");
			qi.values.add(bean.getExperimentid());
			valueSet = true;
		}
		if (bean.getSubjectid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("subjectid=?");
			qi.values.add(bean.getSubjectid());
			valueSet = true;
		}
		if (bean.getExecutedtransformid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("executedtransformid=?");
			qi.values.add(bean.getExecutedtransformid());
			valueSet = true;
		}
		if (bean.getAnalysisid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("analysisid=?");
			qi.values.add(bean.getAnalysisid());
			valueSet = true;
		}
		if (bean.getAnalysisname() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("analysisname=?");
			qi.values.add(bean.getAnalysisname());
			valueSet = true;
		}
		if (bean.getDescription() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("description=?");
			qi.values.add(bean.getDescription());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("owner=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("modtime=?");
			qi.values.add(new java.sql.Date(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("moduser=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getOntologysource() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ontologysource=?");
			qi.values.add(bean.getOntologysource());
			valueSet = true;
		}
		if (bean.getConceptid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("conceptid=?");
			qi.values.add(bean.getConceptid());
			valueSet = true;
		}
		if (bean.getIsbad() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("isbad=?");
			qi.values.add(bean.getIsbad());
			valueSet = true;
		}
		if (bean.getGroupname() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("groupname=?");
			qi.values.add(bean.getGroupname());
			valueSet = true;
		}
		if (bean.getGrouplongname() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("grouplongname=?");
			qi.values.add(bean.getGrouplongname());
			valueSet = true;
		}
		if (bean.getGroupontologysource() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("groupontologysource=?");
			qi.values.add(bean.getGroupontologysource());
			valueSet = true;
		}
		if (bean.getGroupconceptid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("groupconceptid=?");
			qi.values.add(bean.getGroupconceptid());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Analysisresult bean,
			Analysisresult criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE nc_analysisresult SET ");
		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("uniqueid=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getTableid() != null || bean.isNull("tableid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("tableid=? ");
			uqi.setValues.add(bean.getTableid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tableid"), uqi);
			valueSet = true;
		}
		if (bean.getSegmentid() != null || bean.isNull("segmentid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("segmentid=? ");
			uqi.setValues.add(bean.getSegmentid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("segmentid"), uqi);
			valueSet = true;
		}
		if (bean.getComponentid() != null || bean.isNull("componentid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("componentid=? ");
			uqi.setValues.add(bean.getComponentid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("componentid"), uqi);
			valueSet = true;
		}
		if (bean.getExperimentid() != null || bean.isNull("experimentid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("experimentid=? ");
			uqi.setValues.add(bean.getExperimentid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("experimentid"), uqi);
			valueSet = true;
		}
		if (bean.getSubjectid() != null || bean.isNull("subjectid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("subjectid=? ");
			uqi.setValues.add(bean.getSubjectid());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("subjectid"), uqi);
			valueSet = true;
		}
		if (bean.getExecutedtransformid() != null
				|| bean.isNull("executedtransformid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("executedtransformid=? ");
			uqi.setValues.add(bean.getExecutedtransformid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("executedtransformid"), uqi);
			valueSet = true;
		}
		if (bean.getAnalysisid() != null || bean.isNull("analysisid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("analysisid=? ");
			uqi.setValues.add(bean.getAnalysisid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("analysisid"), uqi);
			valueSet = true;
		}
		if (bean.getAnalysisname() != null || bean.isNull("analysisname")) {
			if (valueSet)
				buf.append(", ");
			buf.append("analysisname=? ");
			uqi.setValues.add(bean.getAnalysisname());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("analysisname"), uqi);
			valueSet = true;
		}
		if (bean.getDescription() != null || bean.isNull("description")) {
			if (valueSet)
				buf.append(", ");
			buf.append("description=? ");
			uqi.setValues.add(bean.getDescription());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("description"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("owner=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("modtime=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime()
					.getTime()));
			uqi.sqlTypes.add(new Integer(Types.TIMESTAMP));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("moduser=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (bean.getOntologysource() != null || bean.isNull("ontologysource")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ontologysource=? ");
			uqi.setValues.add(bean.getOntologysource());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("ontologysource"), uqi);
			valueSet = true;
		}
		if (bean.getConceptid() != null || bean.isNull("conceptid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("conceptid=? ");
			uqi.setValues.add(bean.getConceptid());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("conceptid"), uqi);
			valueSet = true;
		}
		if (bean.getIsbad() != null || bean.isNull("isbad")) {
			if (valueSet)
				buf.append(", ");
			buf.append("isbad=? ");
			uqi.setValues.add(bean.getIsbad());
			uqi.sqlTypes.add(new Integer(Types.BOOLEAN));
			prepareNullSetListValue(bean.isNull("isbad"), uqi);
			valueSet = true;
		}
		if (bean.getGroupname() != null || bean.isNull("groupname")) {
			if (valueSet)
				buf.append(", ");
			buf.append("groupname=? ");
			uqi.setValues.add(bean.getGroupname());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("groupname"), uqi);
			valueSet = true;
		}
		if (bean.getGrouplongname() != null || bean.isNull("grouplongname")) {
			if (valueSet)
				buf.append(", ");
			buf.append("grouplongname=? ");
			uqi.setValues.add(bean.getGrouplongname());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("grouplongname"), uqi);
			valueSet = true;
		}
		if (bean.getGroupontologysource() != null
				|| bean.isNull("groupontologysource")) {
			if (valueSet)
				buf.append(", ");
			buf.append("groupontologysource=? ");
			uqi.setValues.add(bean.getGroupontologysource());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("groupontologysource"), uqi);
			valueSet = true;
		}
		if (bean.getGroupconceptid() != null || bean.isNull("groupconceptid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("groupconceptid=? ");
			uqi.setValues.add(bean.getGroupconceptid());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("groupconceptid"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	protected Boolean convert2Boolean(Object columnValue) {
		if (columnValue == null)
			return null;
		return ((java.math.BigDecimal) columnValue).intValue() > 0 ? new Boolean(
				true)
				: new Boolean(false);
	}

	protected BigDecimal boolean2Number(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? new java.math.BigDecimal("1")
				: new java.math.BigDecimal("0");
	}

	protected String boolean2YN(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? "Y" : "N";
	}

	public Analysisresult createObject(ResultSet rs) throws SQLException {
		Analysisresult obj = new Analysisresult();
		obj.setUniqueid((rs.getObject(1) != null) ? new java.math.BigDecimal(rs
				.getObject(1).toString()) : null);
		obj.setTableid((rs.getObject(2) != null) ? new java.math.BigDecimal(rs
				.getObject(2).toString()) : null);
		obj.setSegmentid((rs.getObject(3) != null) ? new java.math.BigDecimal(
				rs.getObject(3).toString()) : null);
		obj
				.setComponentid((rs.getObject(4) != null) ? new java.math.BigDecimal(
						rs.getObject(4).toString())
						: null);
		obj
				.setExperimentid((rs.getObject(5) != null) ? new java.math.BigDecimal(
						rs.getObject(5).toString())
						: null);
		obj.setSubjectid((String) rs.getObject(6));
		obj
				.setExecutedtransformid((rs.getObject(7) != null) ? new java.math.BigDecimal(
						rs.getObject(7).toString())
						: null);
		obj.setAnalysisid((rs.getObject(8) != null) ? new java.math.BigDecimal(
				rs.getObject(8).toString()) : null);
		obj.setAnalysisname((String) rs.getObject(9));
		obj.setDescription((String) rs.getObject(10));
		obj.setOwner((rs.getObject(11) != null) ? new java.math.BigDecimal(rs
				.getObject(11).toString()) : null);
		obj.setModtime((rs.getObject(12) != null) ? new java.util.Date(
				((java.sql.Timestamp) rs.getObject(12)).getTime()) : null);
		obj.setModuser((rs.getObject(13) != null) ? new java.math.BigDecimal(rs
				.getObject(13).toString()) : null);
		obj.setOntologysource((String) rs.getObject(14));
		obj.setConceptid((String) rs.getObject(15));
		obj.setIsbad((Boolean) rs.getObject(16));
		obj.setGroupname((String) rs.getObject(17));
		obj.setGrouplongname((String) rs.getObject(18));
		obj.setGroupontologysource((String) rs.getObject(19));
		obj.setGroupconceptid((String) rs.getObject(20));
		return obj;
	}

	public List<Analysisresult> find(Connection con, Analysisresult criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Analysisresult> results = new LinkedList<Analysisresult>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM nc_analysisresult ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Analysisresult item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Analysisresult bean,
			Analysisresult criteria) throws Exception {
		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Analysisresult criteria)
			throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM nc_analysisresult ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
