package clinical.server.dao.postgres;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.utils.PostgresUtils;
import clinical.server.vo.Assessmentfloat;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class AssessmentfloatDAO implements
		clinical.server.dao.AssessmentfloatDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public AssessmentfloatDAO() {
	}

	public void insert(Connection con, Assessmentfloat bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO nc_assessmentfloat VALUES ");
			buf.append('(');
			for (int i = 0; i < 23; ++i) {
				buf.append('?');
				if (i < 22)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, bean.getTableid(), Types.NUMERIC);

			ps.setObject(2, bean.getNcAssessmentdataUniqueid(), Types.NUMERIC);

			ps.setObject(3, bean.getScoreorder(), Types.NUMERIC);

			ps.setObject(4, bean.getOwner(), Types.NUMERIC);

			ps.setObject(5,
					bean.getModtime() == null ? (java.sql.Timestamp) null
							: new java.sql.Timestamp(bean.getModtime()
									.getTime()));

			ps.setObject(6, bean.getModuser(), Types.NUMERIC);

			ps.setObject(7, bean.getTextvalue(), Types.VARCHAR);

			ps.setObject(8, bean.getTextnormvalue(), Types.VARCHAR);

			ps.setObject(9, bean.getComments(), Types.VARCHAR);

			ps.setObject(10, PostgresUtils.toDouble(bean.getDatavalue()),
					Types.DOUBLE);

			ps.setObject(11, PostgresUtils.toDouble(bean.getDatanormvalue()),
					Types.DOUBLE);

			ps.setObject(12, bean.getStoredassessmentid(), Types.NUMERIC);

			ps.setObject(13, bean.getAssessmentid(), Types.NUMERIC);

			ps.setObject(14, bean.getScorename(), Types.VARCHAR);

			ps.setObject(15, bean.getScoretype(), Types.VARCHAR);

			ps.setObject(16, bean.getIsvalidated());

			ps.setObject(17, bean.getIsranked());

			ps.setObject(18, bean.getSubjectid(), Types.VARCHAR);

			ps.setObject(19, bean.getEntryid(), Types.NUMERIC);

			ps.setObject(20, bean.getKeyerid(), Types.NUMERIC);

			ps.setObject(21, bean.getRaterid(), Types.NUMERIC);

			ps.setObject(22, bean.getClassification(), Types.NUMERIC);

			ps.setObject(23, bean.getUniqueid(), Types.NUMERIC);

			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	protected String prepareColList(Assessmentfloat bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("tableid");
		buf.append(',');
		buf.append("nc_assessmentdata_uniqueid");
		buf.append(',');
		buf.append("scoreorder");
		buf.append(',');
		buf.append("owner");
		buf.append(',');
		buf.append("modtime");
		buf.append(',');
		buf.append("moduser");
		buf.append(',');
		buf.append("textvalue");
		buf.append(',');
		buf.append("textnormvalue");
		buf.append(',');
		buf.append("comments");
		buf.append(',');
		buf.append("datavalue");
		buf.append(',');
		buf.append("datanormvalue");
		buf.append(',');
		buf.append("storedassessmentid");
		buf.append(',');
		buf.append("assessmentid");
		buf.append(',');
		buf.append("scorename");
		buf.append(',');
		buf.append("scoretype");
		buf.append(',');
		buf.append("isvalidated");
		buf.append(',');
		buf.append("isranked");
		buf.append(',');
		buf.append("subjectid");
		buf.append(',');
		buf.append("entryid");
		buf.append(',');
		buf.append("keyerid");
		buf.append(',');
		buf.append("raterid");
		buf.append(',');
		buf.append("classification");
		buf.append(',');
		buf.append("uniqueid");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Assessmentfloat bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");
		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("tableid=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getNcAssessmentdataUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("nc_assessmentdata_uniqueid=?");
			qi.values.add(bean.getNcAssessmentdataUniqueid());
			valueSet = true;
		}
		if (bean.getScoreorder() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("scoreorder=?");
			qi.values.add(bean.getScoreorder());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("owner=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("modtime=?");
			qi.values.add(new java.sql.Date(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("moduser=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getTextvalue() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("textvalue=?");
			qi.values.add(bean.getTextvalue());
			valueSet = true;
		}
		if (bean.getTextnormvalue() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("textnormvalue=?");
			qi.values.add(bean.getTextnormvalue());
			valueSet = true;
		}
		if (bean.getComments() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("comments=?");
			qi.values.add(bean.getComments());
			valueSet = true;
		}
		if (bean.getDatavalue() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("datavalue=?");
			qi.values.add(PostgresUtils.toDouble(bean.getDatavalue()));
			valueSet = true;
		}
		if (bean.getDatanormvalue() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("datanormvalue=?");
			qi.values.add(PostgresUtils.toDouble(bean.getDatanormvalue()));
			valueSet = true;
		}
		if (bean.getStoredassessmentid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("storedassessmentid=?");
			qi.values.add(bean.getStoredassessmentid());
			valueSet = true;
		}
		if (bean.getAssessmentid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("assessmentid=?");
			qi.values.add(bean.getAssessmentid());
			valueSet = true;
		}
		if (bean.getScorename() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("scorename=?");
			qi.values.add(bean.getScorename());
			valueSet = true;
		}
		if (bean.getScoretype() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("scoretype=?");
			qi.values.add(bean.getScoretype());
			valueSet = true;
		}
		if (bean.getIsvalidated() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("isvalidated=?");
			qi.values.add(bean.getIsvalidated());
			valueSet = true;
		}
		if (bean.getIsranked() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("isranked=?");
			qi.values.add(bean.getIsranked());
			valueSet = true;
		}
		if (bean.getSubjectid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("subjectid=?");
			qi.values.add(bean.getSubjectid());
			valueSet = true;
		}
		if (bean.getEntryid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("entryid=?");
			qi.values.add(bean.getEntryid());
			valueSet = true;
		}
		if (bean.getKeyerid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("keyerid=?");
			qi.values.add(bean.getKeyerid());
			valueSet = true;
		}
		if (bean.getRaterid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("raterid=?");
			qi.values.add(bean.getRaterid());
			valueSet = true;
		}
		if (bean.getClassification() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("classification=?");
			qi.values.add(bean.getClassification());
			valueSet = true;
		}
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("uniqueid=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Assessmentfloat bean,
			Assessmentfloat criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE nc_assessmentfloat SET ");
		if (bean.getTableid() != null || bean.isNull("tableid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("tableid=? ");
			uqi.setValues.add(bean.getTableid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tableid"), uqi);
			valueSet = true;
		}
		if (bean.getNcAssessmentdataUniqueid() != null
				|| bean.isNull("ncAssessmentdataUniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("nc_assessmentdata_uniqueid=? ");
			uqi.setValues.add(bean.getNcAssessmentdataUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("ncAssessmentdataUniqueid"),
					uqi);
			valueSet = true;
		}
		if (bean.getScoreorder() != null || bean.isNull("scoreorder")) {
			if (valueSet)
				buf.append(", ");
			buf.append("scoreorder=? ");
			uqi.setValues.add(bean.getScoreorder());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("scoreorder"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("owner=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("modtime=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime()
					.getTime()));
			uqi.sqlTypes.add(new Integer(Types.TIMESTAMP));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("moduser=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (bean.getTextvalue() != null || bean.isNull("textvalue")) {
			if (valueSet)
				buf.append(", ");
			buf.append("textvalue=? ");
			uqi.setValues.add(bean.getTextvalue());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("textvalue"), uqi);
			valueSet = true;
		}
		if (bean.getTextnormvalue() != null || bean.isNull("textnormvalue")) {
			if (valueSet)
				buf.append(", ");
			buf.append("textnormvalue=? ");
			uqi.setValues.add(bean.getTextnormvalue());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("textnormvalue"), uqi);
			valueSet = true;
		}
		if (bean.getComments() != null || bean.isNull("comments")) {
			if (valueSet)
				buf.append(", ");
			buf.append("comments=? ");
			uqi.setValues.add(bean.getComments());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("comments"), uqi);
			valueSet = true;
		}
		if (bean.getDatavalue() != null || bean.isNull("datavalue")) {
			if (valueSet)
				buf.append(", ");
			buf.append("datavalue=? ");
			uqi.setValues.add(PostgresUtils.toDouble(bean.getDatavalue()));
			uqi.sqlTypes.add(new Integer(Types.DOUBLE));
			prepareNullSetListValue(bean.isNull("datavalue"), uqi);
			valueSet = true;
		}
		if (bean.getDatanormvalue() != null || bean.isNull("datanormvalue")) {
			if (valueSet)
				buf.append(", ");
			buf.append("datanormvalue=? ");
			uqi.setValues.add(PostgresUtils.toDouble(bean.getDatanormvalue()));
			uqi.sqlTypes.add(new Integer(Types.DOUBLE));
			prepareNullSetListValue(bean.isNull("datanormvalue"), uqi);
			valueSet = true;
		}
		if (bean.getStoredassessmentid() != null
				|| bean.isNull("storedassessmentid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("storedassessmentid=? ");
			uqi.setValues.add(bean.getStoredassessmentid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("storedassessmentid"), uqi);
			valueSet = true;
		}
		if (bean.getAssessmentid() != null || bean.isNull("assessmentid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("assessmentid=? ");
			uqi.setValues.add(bean.getAssessmentid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("assessmentid"), uqi);
			valueSet = true;
		}
		if (bean.getScorename() != null || bean.isNull("scorename")) {
			if (valueSet)
				buf.append(", ");
			buf.append("scorename=? ");
			uqi.setValues.add(bean.getScorename());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("scorename"), uqi);
			valueSet = true;
		}
		if (bean.getScoretype() != null || bean.isNull("scoretype")) {
			if (valueSet)
				buf.append(", ");
			buf.append("scoretype=? ");
			uqi.setValues.add(bean.getScoretype());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("scoretype"), uqi);
			valueSet = true;
		}
		if (bean.getIsvalidated() != null || bean.isNull("isvalidated")) {
			if (valueSet)
				buf.append(", ");
			buf.append("isvalidated=? ");
			uqi.setValues.add(bean.getIsvalidated());
			uqi.sqlTypes.add(new Integer(Types.BOOLEAN));
			prepareNullSetListValue(bean.isNull("isvalidated"), uqi);
			valueSet = true;
		}
		if (bean.getIsranked() != null || bean.isNull("isranked")) {
			if (valueSet)
				buf.append(", ");
			buf.append("isranked=? ");
			uqi.setValues.add(bean.getIsranked());
			uqi.sqlTypes.add(new Integer(Types.BOOLEAN));
			prepareNullSetListValue(bean.isNull("isranked"), uqi);
			valueSet = true;
		}
		if (bean.getSubjectid() != null || bean.isNull("subjectid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("subjectid=? ");
			uqi.setValues.add(bean.getSubjectid());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("subjectid"), uqi);
			valueSet = true;
		}
		if (bean.getEntryid() != null || bean.isNull("entryid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("entryid=? ");
			uqi.setValues.add(bean.getEntryid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("entryid"), uqi);
			valueSet = true;
		}
		if (bean.getKeyerid() != null || bean.isNull("keyerid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("keyerid=? ");
			uqi.setValues.add(bean.getKeyerid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("keyerid"), uqi);
			valueSet = true;
		}
		if (bean.getRaterid() != null || bean.isNull("raterid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("raterid=? ");
			uqi.setValues.add(bean.getRaterid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("raterid"), uqi);
			valueSet = true;
		}
		if (bean.getClassification() != null || bean.isNull("classification")) {
			if (valueSet)
				buf.append(", ");
			buf.append("classification=? ");
			uqi.setValues.add(bean.getClassification());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("classification"), uqi);
			valueSet = true;
		}
		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("uniqueid=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	protected Boolean convert2Boolean(Object columnValue) {
		if (columnValue == null)
			return null;
		return ((java.math.BigDecimal) columnValue).intValue() > 0 ? new Boolean(
				true)
				: new Boolean(false);
	}

	protected BigDecimal boolean2Number(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? new java.math.BigDecimal("1")
				: new java.math.BigDecimal("0");
	}

	protected String boolean2YN(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? "Y" : "N";
	}

	public Assessmentfloat createObject(ResultSet rs) throws SQLException {
		Assessmentfloat obj = new Assessmentfloat();
		obj.setTableid((rs.getObject(1) != null) ? new java.math.BigDecimal(rs
				.getObject(1).toString()) : null);
		obj
				.setNcAssessmentdataUniqueid((rs.getObject(2) != null) ? new java.math.BigDecimal(
						rs.getObject(2).toString())
						: null);
		obj.setScoreorder((rs.getObject(3) != null) ? new java.math.BigDecimal(
				rs.getObject(3).toString()) : null);
		obj.setOwner((rs.getObject(4) != null) ? new java.math.BigDecimal(rs
				.getObject(4).toString()) : null);
		obj.setModtime((rs.getObject(5) != null) ? new java.util.Date(
				((java.sql.Timestamp) rs.getObject(5)).getTime()) : null);
		obj.setModuser((rs.getObject(6) != null) ? new java.math.BigDecimal(rs
				.getObject(6).toString()) : null);
		obj.setTextvalue((String) rs.getObject(7));
		obj.setTextnormvalue((String) rs.getObject(8));
		obj.setComments((String) rs.getObject(9));
		obj.setDatavalue(PostgresUtils.toFloat(rs.getObject(10)));
		obj.setDatanormvalue(PostgresUtils.toFloat(rs.getObject(11)));
		obj
				.setStoredassessmentid((rs.getObject(12) != null) ? new java.math.BigDecimal(
						rs.getObject(12).toString())
						: null);
		obj
				.setAssessmentid((rs.getObject(13) != null) ? new java.math.BigDecimal(
						rs.getObject(13).toString())
						: null);
		obj.setScorename((String) rs.getObject(14));
		obj.setScoretype((String) rs.getObject(15));
		obj.setIsvalidated((Boolean) rs.getObject(16));
		obj.setIsranked((Boolean) rs.getObject(17));
		obj.setSubjectid((String) rs.getObject(18));
		obj.setEntryid((rs.getObject(19) != null) ? new java.math.BigDecimal(rs
				.getObject(19).toString()) : null);
		obj.setKeyerid((rs.getObject(20) != null) ? new java.math.BigDecimal(rs
				.getObject(20).toString()) : null);
		obj.setRaterid((rs.getObject(21) != null) ? new java.math.BigDecimal(rs
				.getObject(21).toString()) : null);
		obj
				.setClassification((rs.getObject(22) != null) ? new java.math.BigDecimal(
						rs.getObject(22).toString())
						: null);
		obj.setUniqueid((rs.getObject(23) != null) ? new java.math.BigDecimal(
				rs.getObject(23).toString()) : null);
		return obj;
	}

	public List<Assessmentfloat> find(Connection con, Assessmentfloat criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Assessmentfloat> results = new LinkedList<Assessmentfloat>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM nc_assessmentfloat ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Assessmentfloat item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Assessmentfloat bean,
			Assessmentfloat criteria) throws Exception {
		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Assessmentfloat criteria)
			throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM nc_assessmentfloat ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
