package clinical.server.dao.postgres;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.Databaseuser;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class DatabaseuserDAO implements clinical.server.dao.DatabaseuserDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public DatabaseuserDAO() {
	}

	public void insert(Connection con, Databaseuser bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO nc_databaseuser VALUES ");
			buf.append('(');
			for (int i = 0; i < 10; ++i) {
				buf.append('?');
				if (i < 9)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, bean.getUniqueid(), Types.NUMERIC);

			ps.setObject(2, bean.getName(), Types.VARCHAR);

			ps.setObject(3, bean.getTableid(), Types.NUMERIC);

			ps.setObject(4, bean.getOwner(), Types.NUMERIC);

			ps.setObject(5,
					bean.getModtime() == null ? (java.sql.Timestamp) null
							: new java.sql.Timestamp(bean.getModtime()
									.getTime()));

			ps.setObject(6, bean.getModuser(), Types.NUMERIC);

			ps.setObject(7, bean.getUserclass(), Types.NUMERIC);

			ps.setObject(8, bean.getUserstatus(), Types.NUMERIC);

			ps.setObject(9, bean.getIsgroup());

			ps.setObject(10, bean.getPersonid(), Types.NUMERIC);

			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	protected String prepareColList(Databaseuser bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("uniqueid");
		buf.append(',');
		buf.append("name");
		buf.append(',');
		buf.append("tableid");
		buf.append(',');
		buf.append("owner");
		buf.append(',');
		buf.append("modtime");
		buf.append(',');
		buf.append("moduser");
		buf.append(',');
		buf.append("userclass");
		buf.append(',');
		buf.append("userstatus");
		buf.append(',');
		buf.append("isgroup");
		buf.append(',');
		buf.append("personid");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Databaseuser bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("uniqueid=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getName() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("name=?");
			qi.values.add(bean.getName());
			valueSet = true;
		}
		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("tableid=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("owner=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("modtime=?");
			qi.values.add(new java.sql.Date(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("moduser=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getUserclass() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("userclass=?");
			qi.values.add(bean.getUserclass());
			valueSet = true;
		}
		if (bean.getUserstatus() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("userstatus=?");
			qi.values.add(bean.getUserstatus());
			valueSet = true;
		}
		if (bean.getIsgroup() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("isgroup=?");
			qi.values.add(bean.getIsgroup());
			valueSet = true;
		}
		if (bean.getPersonid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("personid=?");
			qi.values.add(bean.getPersonid());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Databaseuser bean,
			Databaseuser criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE nc_databaseuser SET ");
		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("uniqueid=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getName() != null || bean.isNull("name")) {
			if (valueSet)
				buf.append(", ");
			buf.append("name=? ");
			uqi.setValues.add(bean.getName());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("name"), uqi);
			valueSet = true;
		}
		if (bean.getTableid() != null || bean.isNull("tableid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("tableid=? ");
			uqi.setValues.add(bean.getTableid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tableid"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("owner=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("modtime=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime()
					.getTime()));
			uqi.sqlTypes.add(new Integer(Types.TIMESTAMP));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("moduser=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (bean.getUserclass() != null || bean.isNull("userclass")) {
			if (valueSet)
				buf.append(", ");
			buf.append("userclass=? ");
			uqi.setValues.add(bean.getUserclass());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("userclass"), uqi);
			valueSet = true;
		}
		if (bean.getUserstatus() != null || bean.isNull("userstatus")) {
			if (valueSet)
				buf.append(", ");
			buf.append("userstatus=? ");
			uqi.setValues.add(bean.getUserstatus());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("userstatus"), uqi);
			valueSet = true;
		}
		if (bean.getIsgroup() != null || bean.isNull("isgroup")) {
			if (valueSet)
				buf.append(", ");
			buf.append("isgroup=? ");
			uqi.setValues.add(bean.getIsgroup());
			uqi.sqlTypes.add(new Integer(Types.BOOLEAN));
			prepareNullSetListValue(bean.isNull("isgroup"), uqi);
			valueSet = true;
		}
		if (bean.getPersonid() != null || bean.isNull("personid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("personid=? ");
			uqi.setValues.add(bean.getPersonid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("personid"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	protected Boolean convert2Boolean(Object columnValue) {
		if (columnValue == null)
			return null;
		return ((java.math.BigDecimal) columnValue).intValue() > 0 ? new Boolean(
				true)
				: new Boolean(false);
	}

	protected BigDecimal boolean2Number(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? new java.math.BigDecimal("1")
				: new java.math.BigDecimal("0");
	}

	protected String boolean2YN(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? "Y" : "N";
	}

	public Databaseuser createObject(ResultSet rs) throws SQLException {
		Databaseuser obj = new Databaseuser();
		obj.setUniqueid((rs.getObject(1) != null) ? new java.math.BigDecimal(rs
				.getObject(1).toString()) : null);
		obj.setName((String) rs.getObject(2));
		obj.setTableid((rs.getObject(3) != null) ? new java.math.BigDecimal(rs
				.getObject(3).toString()) : null);
		obj.setOwner((rs.getObject(4) != null) ? new java.math.BigDecimal(rs
				.getObject(4).toString()) : null);
		obj.setModtime((rs.getObject(5) != null) ? new java.util.Date(
				((java.sql.Timestamp) rs.getObject(5)).getTime()) : null);
		obj.setModuser((rs.getObject(6) != null) ? new java.math.BigDecimal(rs
				.getObject(6).toString()) : null);
		obj.setUserclass((rs.getObject(7) != null) ? new java.math.BigDecimal(
				rs.getObject(7).toString()) : null);
		obj.setUserstatus((rs.getObject(8) != null) ? new java.math.BigDecimal(
				rs.getObject(8).toString()) : null);
		obj.setIsgroup((Boolean) rs.getObject(9));
		obj.setPersonid((rs.getObject(10) != null) ? new java.math.BigDecimal(
				rs.getObject(10).toString()) : null);
		return obj;
	}

	public List<Databaseuser> find(Connection con, Databaseuser criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Databaseuser> results = new LinkedList<Databaseuser>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM nc_databaseuser ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Databaseuser item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Databaseuser bean, Databaseuser criteria)
			throws Exception {
		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Databaseuser criteria) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM nc_databaseuser ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
