package clinical.server.dao.postgres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.Executedtransform;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class ExecutedtransformDAO implements
		clinical.server.dao.ExecutedtransformDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public ExecutedtransformDAO() {
	}

	public void insert(Connection con, Executedtransform bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO nc_executedtransform VALUES ");
			buf.append('(');
			for (int i = 0; i < 15; ++i) {
				buf.append('?');
				if (i < 14)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, bean.getUniqueid(), Types.NUMERIC);

			ps.setObject(2, bean.getTableid(), Types.NUMERIC);

			ps.setObject(3, bean.getOwner(), Types.NUMERIC);

			ps.setObject(4,
					bean.getModtime() == null ? (java.sql.Timestamp) null
							: new java.sql.Timestamp(bean.getModtime()
									.getTime()));

			ps.setObject(5, bean.getModuser(), Types.NUMERIC);

			ps.setObject(6, bean.getLogicaltransformid(), Types.NUMERIC);

			ps.setObject(7, bean.getNcDatabaseuserUniqueid(), Types.NUMERIC);

			ps.setObject(8, bean.getMachineid(), Types.NUMERIC);

			ps.setObject(9, bean.getTimeStamp(), Types.TIMESTAMP);

			ps.setObject(10, bean.getCompilerid(), Types.NUMERIC);

			ps.setObject(11, bean.getAnalysiscomponentid(), Types.NUMERIC);

			ps.setObject(12, bean.getParentexecutedtransformationid(),
					Types.NUMERIC);

			ps.setObject(13, bean.getNodelevel(), Types.NUMERIC);

			ps.setObject(14, bean.getAnalysisid(), Types.NUMERIC);

			ps.setObject(15, bean.getArgumentsused(), Types.VARCHAR);

			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	protected String prepareColList(Executedtransform bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("uniqueid");
		buf.append(',');
		buf.append("tableid");
		buf.append(',');
		buf.append("owner");
		buf.append(',');
		buf.append("modtime");
		buf.append(',');
		buf.append("moduser");
		buf.append(',');
		buf.append("logicaltransformid");
		buf.append(',');
		buf.append("nc_databaseuser_uniqueid");
		buf.append(',');
		buf.append("machineid");
		buf.append(',');
		buf.append("time_stamp");
		buf.append(',');
		buf.append("compilerid");
		buf.append(',');
		buf.append("analysiscomponentid");
		buf.append(',');
		buf.append("parentexecutedtransformationid");
		buf.append(',');
		buf.append("nodelevel");
		buf.append(',');
		buf.append("analysisid");
		buf.append(',');
		buf.append("argumentsused");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Executedtransform bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("uniqueid=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("tableid=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("owner=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("modtime=?");
			qi.values.add(new java.sql.Date(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("moduser=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getLogicaltransformid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("logicaltransformid=?");
			qi.values.add(bean.getLogicaltransformid());
			valueSet = true;
		}
		if (bean.getNcDatabaseuserUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("nc_databaseuser_uniqueid=?");
			qi.values.add(bean.getNcDatabaseuserUniqueid());
			valueSet = true;
		}
		if (bean.getMachineid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("machineid=?");
			qi.values.add(bean.getMachineid());
			valueSet = true;
		}
		if (bean.getTimeStamp() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("time_stamp=?");
			qi.values.add(bean.getTimeStamp());
			valueSet = true;
		}
		if (bean.getCompilerid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("compilerid=?");
			qi.values.add(bean.getCompilerid());
			valueSet = true;
		}
		if (bean.getAnalysiscomponentid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("analysiscomponentid=?");
			qi.values.add(bean.getAnalysiscomponentid());
			valueSet = true;
		}
		if (bean.getParentexecutedtransformationid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("parentexecutedtransformationid=?");
			qi.values.add(bean.getParentexecutedtransformationid());
			valueSet = true;
		}
		if (bean.getNodelevel() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("nodelevel=?");
			qi.values.add(bean.getNodelevel());
			valueSet = true;
		}
		if (bean.getAnalysisid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("analysisid=?");
			qi.values.add(bean.getAnalysisid());
			valueSet = true;
		}
		if (bean.getArgumentsused() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("argumentsused=?");
			qi.values.add(bean.getArgumentsused());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Executedtransform bean,
			Executedtransform criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE nc_executedtransform SET ");
		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("uniqueid=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getTableid() != null || bean.isNull("tableid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("tableid=? ");
			uqi.setValues.add(bean.getTableid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tableid"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("owner=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("modtime=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime()
					.getTime()));
			uqi.sqlTypes.add(new Integer(Types.TIMESTAMP));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("moduser=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (bean.getLogicaltransformid() != null
				|| bean.isNull("logicaltransformid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("logicaltransformid=? ");
			uqi.setValues.add(bean.getLogicaltransformid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("logicaltransformid"), uqi);
			valueSet = true;
		}
		if (bean.getNcDatabaseuserUniqueid() != null
				|| bean.isNull("ncDatabaseuserUniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("nc_databaseuser_uniqueid=? ");
			uqi.setValues.add(bean.getNcDatabaseuserUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("ncDatabaseuserUniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getMachineid() != null || bean.isNull("machineid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("machineid=? ");
			uqi.setValues.add(bean.getMachineid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("machineid"), uqi);
			valueSet = true;
		}
		if (bean.getTimeStamp() != null || bean.isNull("timeStamp")) {
			if (valueSet)
				buf.append(", ");
			buf.append("time_stamp=? ");
			uqi.setValues.add(bean.getTimeStamp());
			uqi.sqlTypes.add(new Integer(Types.TIMESTAMP));
			prepareNullSetListValue(bean.isNull("timeStamp"), uqi);
			valueSet = true;
		}
		if (bean.getCompilerid() != null || bean.isNull("compilerid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("compilerid=? ");
			uqi.setValues.add(bean.getCompilerid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("compilerid"), uqi);
			valueSet = true;
		}
		if (bean.getAnalysiscomponentid() != null
				|| bean.isNull("analysiscomponentid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("analysiscomponentid=? ");
			uqi.setValues.add(bean.getAnalysiscomponentid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("analysiscomponentid"), uqi);
			valueSet = true;
		}
		if (bean.getParentexecutedtransformationid() != null
				|| bean.isNull("parentexecutedtransformationid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("parentexecutedtransformationid=? ");
			uqi.setValues.add(bean.getParentexecutedtransformationid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean
					.isNull("parentexecutedtransformationid"), uqi);
			valueSet = true;
		}
		if (bean.getNodelevel() != null || bean.isNull("nodelevel")) {
			if (valueSet)
				buf.append(", ");
			buf.append("nodelevel=? ");
			uqi.setValues.add(bean.getNodelevel());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("nodelevel"), uqi);
			valueSet = true;
		}
		if (bean.getAnalysisid() != null || bean.isNull("analysisid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("analysisid=? ");
			uqi.setValues.add(bean.getAnalysisid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("analysisid"), uqi);
			valueSet = true;
		}
		if (bean.getArgumentsused() != null || bean.isNull("argumentsused")) {
			if (valueSet)
				buf.append(", ");
			buf.append("argumentsused=? ");
			uqi.setValues.add(bean.getArgumentsused());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("argumentsused"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	public Executedtransform createObject(ResultSet rs) throws SQLException {
		Executedtransform obj = new Executedtransform();
		obj.setUniqueid((rs.getObject(1) != null) ? new java.math.BigDecimal(rs
				.getObject(1).toString()) : null);
		obj.setTableid((rs.getObject(2) != null) ? new java.math.BigDecimal(rs
				.getObject(2).toString()) : null);
		obj.setOwner((rs.getObject(3) != null) ? new java.math.BigDecimal(rs
				.getObject(3).toString()) : null);
		obj.setModtime((rs.getObject(4) != null) ? new java.util.Date(
				((java.sql.Timestamp) rs.getObject(4)).getTime()) : null);
		obj.setModuser((rs.getObject(5) != null) ? new java.math.BigDecimal(rs
				.getObject(5).toString()) : null);
		obj
				.setLogicaltransformid((rs.getObject(6) != null) ? new java.math.BigDecimal(
						rs.getObject(6).toString())
						: null);
		obj
				.setNcDatabaseuserUniqueid((rs.getObject(7) != null) ? new java.math.BigDecimal(
						rs.getObject(7).toString())
						: null);
		obj.setMachineid((rs.getObject(8) != null) ? new java.math.BigDecimal(
				rs.getObject(8).toString()) : null);
		obj.setTimeStamp((java.sql.Timestamp) rs.getObject(9));
		obj
				.setCompilerid((rs.getObject(10) != null) ? new java.math.BigDecimal(
						rs.getObject(10).toString())
						: null);
		obj
				.setAnalysiscomponentid((rs.getObject(11) != null) ? new java.math.BigDecimal(
						rs.getObject(11).toString())
						: null);
		obj
				.setParentexecutedtransformationid((rs.getObject(12) != null) ? new java.math.BigDecimal(
						rs.getObject(12).toString())
						: null);
		obj.setNodelevel((rs.getObject(13) != null) ? new java.math.BigDecimal(
				rs.getObject(13).toString()) : null);
		obj
				.setAnalysisid((rs.getObject(14) != null) ? new java.math.BigDecimal(
						rs.getObject(14).toString())
						: null);
		obj.setArgumentsused((String) rs.getObject(15));
		return obj;
	}

	public List<Executedtransform> find(Connection con,
			Executedtransform criteria) throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Executedtransform> results = new LinkedList<Executedtransform>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM nc_executedtransform ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Executedtransform item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Executedtransform bean,
			Executedtransform criteria) throws Exception {
		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Executedtransform criteria)
			throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM nc_executedtransform ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
