package clinical.server.dao.postgres;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.Tuplecolumns;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class TuplecolumnsDAO implements clinical.server.dao.TuplecolumnsDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public TuplecolumnsDAO() {
	}

	public void insert(Connection con, Tuplecolumns bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO nc_tuplecolumns VALUES ");
			buf.append('(');
			for (int i = 0; i < 14; ++i) {
				buf.append('?');
				if (i < 13)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, bean.getExtendedtupleid(), Types.NUMERIC);

			ps.setObject(2, bean.getColumnname(), Types.VARCHAR);

			ps.setObject(3, bean.getColumntype(), Types.VARCHAR);

			ps.setObject(4, bean.getTableid(), Types.NUMERIC);

			ps.setObject(5, bean.getUniqueid(), Types.NUMERIC);

			ps.setObject(6, bean.getOwner(), Types.NUMERIC);

			ps.setObject(7,
					bean.getModtime() == null ? (java.sql.Timestamp) null
							: new java.sql.Timestamp(bean.getModtime()
									.getTime()));

			ps.setObject(8, bean.getModuser(), Types.NUMERIC);

			ps.setObject(9, bean.getDefaultvalue(), Types.VARCHAR);

			ps.setObject(10, bean.getNullable());

			ps.setObject(11, bean.getColumnontology(), Types.VARCHAR);

			ps.setObject(12, bean.getColumnconcept(), Types.VARCHAR);

			ps.setObject(13, bean.getMeasurementsystem(), Types.VARCHAR);

			ps.setObject(14, bean.getMeasurementunit(), Types.VARCHAR);

			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	protected String prepareColList(Tuplecolumns bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("extendedtupleid");
		buf.append(',');
		buf.append("columnname");
		buf.append(',');
		buf.append("columntype");
		buf.append(',');
		buf.append("tableid");
		buf.append(',');
		buf.append("uniqueid");
		buf.append(',');
		buf.append("owner");
		buf.append(',');
		buf.append("modtime");
		buf.append(',');
		buf.append("moduser");
		buf.append(',');
		buf.append("defaultvalue");
		buf.append(',');
		buf.append("nullable");
		buf.append(',');
		buf.append("columnontology");
		buf.append(',');
		buf.append("columnconcept");
		buf.append(',');
		buf.append("measurementsystem");
		buf.append(',');
		buf.append("measurementunit");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Tuplecolumns bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");
		if (bean.getExtendedtupleid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("extendedtupleid=?");
			qi.values.add(bean.getExtendedtupleid());
			valueSet = true;
		}
		if (bean.getColumnname() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("columnname=?");
			qi.values.add(bean.getColumnname());
			valueSet = true;
		}
		if (bean.getColumntype() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("columntype=?");
			qi.values.add(bean.getColumntype());
			valueSet = true;
		}
		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("tableid=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("uniqueid=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("owner=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("modtime=?");
			qi.values.add(new java.sql.Date(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("moduser=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getDefaultvalue() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("defaultvalue=?");
			qi.values.add(bean.getDefaultvalue());
			valueSet = true;
		}
		if (bean.getNullable() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("nullable=?");
			qi.values.add(bean.getNullable());
			valueSet = true;
		}
		if (bean.getColumnontology() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("columnontology=?");
			qi.values.add(bean.getColumnontology());
			valueSet = true;
		}
		if (bean.getColumnconcept() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("columnconcept=?");
			qi.values.add(bean.getColumnconcept());
			valueSet = true;
		}
		if (bean.getMeasurementsystem() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("measurementsystem=?");
			qi.values.add(bean.getMeasurementsystem());
			valueSet = true;
		}
		if (bean.getMeasurementunit() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("measurementunit=?");
			qi.values.add(bean.getMeasurementunit());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Tuplecolumns bean,
			Tuplecolumns criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE nc_tuplecolumns SET ");
		if (bean.getExtendedtupleid() != null || bean.isNull("extendedtupleid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("extendedtupleid=? ");
			uqi.setValues.add(bean.getExtendedtupleid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("extendedtupleid"), uqi);
			valueSet = true;
		}
		if (bean.getColumnname() != null || bean.isNull("columnname")) {
			if (valueSet)
				buf.append(", ");
			buf.append("columnname=? ");
			uqi.setValues.add(bean.getColumnname());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("columnname"), uqi);
			valueSet = true;
		}
		if (bean.getColumntype() != null || bean.isNull("columntype")) {
			if (valueSet)
				buf.append(", ");
			buf.append("columntype=? ");
			uqi.setValues.add(bean.getColumntype());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("columntype"), uqi);
			valueSet = true;
		}
		if (bean.getTableid() != null || bean.isNull("tableid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("tableid=? ");
			uqi.setValues.add(bean.getTableid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tableid"), uqi);
			valueSet = true;
		}
		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("uniqueid=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("owner=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("modtime=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime()
					.getTime()));
			uqi.sqlTypes.add(new Integer(Types.TIMESTAMP));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("moduser=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (bean.getDefaultvalue() != null || bean.isNull("defaultvalue")) {
			if (valueSet)
				buf.append(", ");
			buf.append("defaultvalue=? ");
			uqi.setValues.add(bean.getDefaultvalue());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("defaultvalue"), uqi);
			valueSet = true;
		}
		if (bean.getNullable() != null || bean.isNull("nullable")) {
			if (valueSet)
				buf.append(", ");
			buf.append("nullable=? ");
			uqi.setValues.add(bean.getNullable());
			uqi.sqlTypes.add(new Integer(Types.BOOLEAN));
			prepareNullSetListValue(bean.isNull("nullable"), uqi);
			valueSet = true;
		}
		if (bean.getColumnontology() != null || bean.isNull("columnontology")) {
			if (valueSet)
				buf.append(", ");
			buf.append("columnontology=? ");
			uqi.setValues.add(bean.getColumnontology());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("columnontology"), uqi);
			valueSet = true;
		}
		if (bean.getColumnconcept() != null || bean.isNull("columnconcept")) {
			if (valueSet)
				buf.append(", ");
			buf.append("columnconcept=? ");
			uqi.setValues.add(bean.getColumnconcept());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("columnconcept"), uqi);
			valueSet = true;
		}
		if (bean.getMeasurementsystem() != null
				|| bean.isNull("measurementsystem")) {
			if (valueSet)
				buf.append(", ");
			buf.append("measurementsystem=? ");
			uqi.setValues.add(bean.getMeasurementsystem());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("measurementsystem"), uqi);
			valueSet = true;
		}
		if (bean.getMeasurementunit() != null || bean.isNull("measurementunit")) {
			if (valueSet)
				buf.append(", ");
			buf.append("measurementunit=? ");
			uqi.setValues.add(bean.getMeasurementunit());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("measurementunit"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	protected Boolean convert2Boolean(Object columnValue) {
		if (columnValue == null)
			return null;
		return ((java.math.BigDecimal) columnValue).intValue() > 0 ? new Boolean(
				true)
				: new Boolean(false);
	}

	protected BigDecimal boolean2Number(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? new java.math.BigDecimal("1")
				: new java.math.BigDecimal("0");
	}

	protected String boolean2YN(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? "Y" : "N";
	}

	public Tuplecolumns createObject(ResultSet rs) throws SQLException {
		Tuplecolumns obj = new Tuplecolumns();
		obj
				.setExtendedtupleid((rs.getObject(1) != null) ? new java.math.BigDecimal(
						rs.getObject(1).toString())
						: null);
		obj.setColumnname((String) rs.getObject(2));
		obj.setColumntype((String) rs.getObject(3));
		obj.setTableid((rs.getObject(4) != null) ? new java.math.BigDecimal(rs
				.getObject(4).toString()) : null);
		obj.setUniqueid((rs.getObject(5) != null) ? new java.math.BigDecimal(rs
				.getObject(5).toString()) : null);
		obj.setOwner((rs.getObject(6) != null) ? new java.math.BigDecimal(rs
				.getObject(6).toString()) : null);
		obj.setModtime((rs.getObject(7) != null) ? new java.util.Date(
				((java.sql.Timestamp) rs.getObject(7)).getTime()) : null);
		obj.setModuser((rs.getObject(8) != null) ? new java.math.BigDecimal(rs
				.getObject(8).toString()) : null);
		obj.setDefaultvalue((String) rs.getObject(9));
		obj.setNullable((Boolean) rs.getObject(10));
		obj.setColumnontology((String) rs.getObject(11));
		obj.setColumnconcept((String) rs.getObject(12));
		obj.setMeasurementsystem((String) rs.getObject(13));
		obj.setMeasurementunit((String) rs.getObject(14));
		return obj;
	}

	public List<Tuplecolumns> find(Connection con, Tuplecolumns criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Tuplecolumns> results = new LinkedList<Tuplecolumns>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM nc_tuplecolumns ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Tuplecolumns item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Tuplecolumns bean, Tuplecolumns criteria)
			throws Exception {
		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Tuplecolumns criteria) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM nc_tuplecolumns ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
