package clinical.server.upload;

public class ColumnInfo {
  protected int type;
  protected String name;
  protected int colIdx;
  protected IConditioner conditioner;


  public ColumnInfo() {}

  public ColumnInfo(String name, int colIdx) {
    this(name, colIdx, null);
  }
  public ColumnInfo(String name, int colIdx, IConditioner cond) {
    this.name = name;
    this.colIdx = colIdx;
    this.conditioner = cond;
  }

  //---------------------- setters --------------
  public void setColIdx(int newColIdx) { this.colIdx = newColIdx; }
  public void setName(String newName) { this.name = newName; }
  public void setConditioner(IConditioner newConditioner) { this.conditioner = newConditioner; }
//---------------------- getters --------------
  public int getColIdx() { return this.colIdx; }
  public String getName() { return this.name; }
  public IConditioner getConditioner() { return this.conditioner; }

  public String getColValue(String[] row) {
     return row[ colIdx];
  }

  public Object transform(String[] row) throws ConditionException {
    if (conditioner != null)
        return conditioner.transform( row[ colIdx ] );
    return row[ colIdx];
  }

}