package clinical.test;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Iterator;
import java.util.List;

import junit.framework.Test;
import junit.framework.TestSuite;
import clinical.server.AssessmentManager;
import clinical.server.ScoreInfo;
import clinical.server.Utils;
import clinical.server.dao.oracle.AssessmentDAO;
import clinical.server.dao.oracle.AssessmentintegerDAO;
import clinical.server.dao.oracle.AssessmentvarcharDAO;
import clinical.server.dao.oracle.ExpcomponentDAO;
import clinical.server.dao.oracle.ExperimentDAO;
import clinical.server.vo.Assessment;
import clinical.server.vo.Assessmentinteger;
import clinical.server.vo.Assessmentscore;
import clinical.server.vo.Assessmentvarchar;
import clinical.server.vo.Expcomponent;
import clinical.server.vo.Experiment;
import clinical.web.Constants;

public class AssessmentManTest extends MyTestCase {
	protected Connection con;
	protected String owner;
	protected String modUser;
	protected BigDecimal secLabel = new BigDecimal("11000");

	public AssessmentManTest(String testName, String propsFile)
			throws IOException {
		super(testName, propsFile);
	}

	protected void setUp() throws Exception {
		Class.forName("oracle.jdbc.driver.OracleDriver");

		owner = getProperty("mbirn.owner");
		modUser = getProperty("mbirn.moduser");
		String dbURL = getProperty("mbirn.dburl");
		String user = getProperty("mbirn.user");
		String pwd = getProperty("mbirn.pwd");
		con = DriverManager.getConnection(dbURL, user, pwd);
		System.out.println("Got connection");
	}

	protected void tearDown() throws Exception {
		if (con != null) {
			System.out.println("closing connection.");
			try {
				con.close();
			} catch (Exception x) {
			}
		}
	}

	public void testAssessment() throws Exception {
		AssessmentManager asMan = new AssessmentManager();
		String asName = "WCS";
		String asDescp = "Wisconsin Card Sorting Test";

		BigDecimal asID = null;
		asID = asMan.addAssessment(con, asName, asDescp, owner, modUser,
				secLabel);
		// asID = new BigDecimal("2702");

		AssessmentDAO dao = new AssessmentDAO();
		Assessment criteria = new Assessment();
		criteria.setName(asName);
		List<Assessment> asList = dao.find(con, criteria);
		assertTrue(asList.size() == 1
				&& ((Assessment) asList.get(0)).getName().equals(asName));

		// add assessment score
		Assessment as = new Assessment();
		as.setAssessmentid(asID);
		as.setName(asName);
		Assessmentscore score = new Assessmentscore();
		score.setScorename("Errors");
		score.setScoretype("integer");
		score.setScorelevel(new BigDecimal("0"));
		ScoreInfo si = new ScoreInfo(as, score);

		asMan.addAssessmentScore2(con, asName, owner, modUser, secLabel, score
				.getScorename(), score.getScoretype(), score.getScorelevel(),
				null, null, // scoreLevel, parentAsID, parentScore
				"DI", null, true, "UMLS", "Assessment");

		addScoreValues(con, asMan, si);

		List<?> scoreValues = getScoreValues(con, si);
		for (Iterator<?> iter = scoreValues.iterator(); iter.hasNext();) {
			Object value = (Object) iter.next();
			System.out.println(value);
		}

		// now remove the assessment
		asMan.removeAssessmentFull(con, asName, owner, modUser);
		/*
		 * asMan.removeAssessmentScore(con, asName, owner, modUser,
		 * score.getScorename() ); scoreValues = getScoreValues(con, si); // now
		 * there must be no score values assertTrue(scoreValues.isEmpty());
		 * 
		 * asMan.removeAssessment(con, asName);
		 */
		Assessment a = getAssessment(con, asName);
		assertNull(a);
	}

	protected Assessment getAssessment(Connection con, String asName)
			throws Exception {
		Assessment criteria = new Assessment();
		AssessmentDAO dao = new AssessmentDAO();
		criteria.setName(asName);
		List<Assessment> asList = dao.find(con, criteria);
		if (asList.isEmpty())
			return null;
		return asList.get(0);
	}

	protected void addScoreValues(Connection con, AssessmentManager asMan,
			ScoreInfo si) throws Exception {
		ExperimentDAO dao = new ExperimentDAO();
		Experiment criteria = new Experiment();
		criteria.setName("Alzheimer Testbed");
		List<Experiment> exps = dao.find(con, criteria);
		if (exps.isEmpty())
			fail("No experiment named Alzheimer Testbed has found!");
		int expID = ((Experiment) exps.get(0)).getUniqueid().intValue();
		int segmentID = 1;
		String[] subjectIDs = { "UCSD43372672", "UCSD00156805" };
		for (int i = 0; i < subjectIDs.length; ++i) {
			Expcomponent visit = getVisit(con, subjectIDs[i], expID,
					Constants.VISIT_TYPE_SCAN);
			si.addValue(new Integer(4), null,
					visit.getComponentid().intValue(), segmentID, expID,
					subjectIDs[i], new java.util.Date(visit.getTimeStamp()
							.getTime()), null);
		}

		asMan.addScoreValues(con, si, owner, modUser, secLabel, false, null);

	}

	protected List<?> getScoreValues(Connection con, ScoreInfo si)
			throws Exception {
		String scoreName = si.getAsScore().getScorename();
		String scoreType = si.getAsScore().getScoretype();
		if (scoreType.equals("integer")) {
			return getAssessmentIntValues(con, scoreName);
		} else if (scoreType.equals("varchar")) {
			return getAssessmentVarcharValues(con, scoreName);
		} else {
			throw new RuntimeException("Score type " + scoreType
					+ " is not supported!");
		}

	}

	List<Assessmentvarchar> getAssessmentVarcharValues(Connection con, String asScoreName)
			throws Exception {
		Assessmentvarchar criteria = new Assessmentvarchar();

		AssessmentvarcharDAO dao = new AssessmentvarcharDAO();
		criteria.setScorename(asScoreName);

		List<Assessmentvarchar> valueList = dao.find(con, criteria);
		return valueList;
	}

	List<Assessmentinteger> getAssessmentIntValues(Connection con, String asScoreName)
			throws Exception {
		Assessmentinteger criteria = new Assessmentinteger();
		AssessmentintegerDAO dao = new AssessmentintegerDAO();
		criteria.setScorename(asScoreName);
		List<Assessmentinteger> valueList = dao.find(con, criteria);
		return valueList;
	}

	protected Expcomponent getVisit(Connection con, String subjectID,
			int experimentID, String visitType) throws Exception {
		Expcomponent criteria = new Expcomponent();
		criteria.setSubjectid(subjectID);
		criteria.setVisittype(visitType);
		criteria.setNcExperimentUniqueid(new BigDecimal("" + experimentID));
		ExpcomponentDAO dao = new ExpcomponentDAO();
		List<Expcomponent> visits = dao.find(con, criteria);

		return  visits.get(0);
	}

	public void testScores() throws Exception {
		AssessmentManager asMan = new AssessmentManager();

		System.out.println("Adding assessment scores");
		asMan.addAssessmentScore(con, "WCS", owner, modUser, "Errors",
				"integer", "DI", null, true, "UMLS", "Assessment");
		asMan.removeAssessmentScore(con, "WCS", owner, modUser, "Errors");
		System.out.println("assessment score test finished successfully");
	}

	public void testScoreValues(Connection con, String owner, String modUser,
			BigDecimal secLabel) throws Exception {
		AssessmentManager asMan = new AssessmentManager();

		Assessment as = new Assessment();
		as.setAssessmentid(new BigDecimal("43"));
		as.setName("WCS");
		Assessmentscore score = new Assessmentscore();
		score.setScorename("Errors");
		score.setScoretype("integer");
		ScoreInfo si = new ScoreInfo(as, score);
		/** @todo check segmentID */
		si.addValue(new Integer(28), null, 42, 1/* segment id */, 16,
				"UCSD0001", Utils.parseUSDate("06/25/1996"), null);
		System.out.println("Now adding test score values");
		asMan.addScoreValues(con, si, owner, modUser, secLabel, false, null);

		// finally remove the score values
		asMan.removeScoreValues(con, si, owner, modUser);

	}

	public static Test suite() throws IOException {
		TestSuite suite = new TestSuite();
		suite.addTest(new AssessmentManTest("testAssessment",
						"test.properties"));
		return suite;
	}

	public static void main(String[] args) throws IOException {
		junit.textui.TestRunner.run(suite());
	}
}
