package clinical.test;

import java.util.List;

import junit.framework.TestCase;

import clinical.server.vo.Person;
import clinical.web.IExperimentManagement;
import clinical.web.ServiceFactory;
import clinical.web.common.UserInfo;
import clinical.web.vo.ExperimentInfo;

/**
 * A helper class used in creating the necessary database state to run database
 * test harnesses independent of each other. After each test, the state created
 * in the database for that test is cleaned.
 * 
 * @author I. Burak Ozyurt
 * @version $Id: DBStateManHelper.java 365 2011-05-05 20:04:18Z bozyurt $
 */
public class DBStateManHelper {

	public static void addExperiment(UserInfo ui, String dbID) throws Exception {
		try {
			IExperimentManagement iem = ServiceFactory
					.getExperimentManagement(dbID);
			List<Person> contactList = iem.getAllContactPersons(ui);
			TestCase.assertTrue("Expecting nonempty contact list!",
					!contactList.isEmpty());
			Person cp = contactList.get(0);
			ExperimentInfo expInfo = new ExperimentInfo();
			expInfo.setName("My Test Experiment");
			expInfo.setContactPersonValue(cp.getUniqueid().toString());

			iem.addExperiment(ui, expInfo);
		} catch (Throwable t) {
			throw new Exception(t);
		}
	}
}
