package clinical.test;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Iterator;
import java.util.List;

import junit.framework.Test;
import junit.framework.TestSuite;
import clinical.server.ExperimentInfo;
import clinical.server.ExperimentManager;
import clinical.server.vo.Subjexperiment;
import clinical.web.Constants;

/**
 * @author I. Burak Ozyurt
 * @version $Id: ExpManTest.java 365 2011-05-05 20:04:18Z bozyurt $
 */
public class ExpManTest extends MyTestCase {
	protected Connection con;
	protected String owner;
	protected String modUser;
	protected String dbID;

	public ExpManTest(String testName, String propsFile) throws IOException {
		super(testName, propsFile);
		dbID = getProperty("mbirn.dbid");
	}

	protected void setUp() throws Exception {
		Class.forName("oracle.jdbc.driver.OracleDriver");

		owner = getProperty("mbirn.owner");
		modUser = getProperty("mbirn.moduser");
		String dbURL = getProperty("mbirn.dburl");
		String user = getProperty("mbirn.user");
		String pwd = getProperty("mbirn.pwd");
		con = DriverManager.getConnection(dbURL, user, pwd);
		System.out.println("Got connection");
	}

	protected void tearDown() throws Exception {
		if (con != null) {
			System.out.println("closing connection.");
			try {
				con.close();
			} catch (Exception x) {
			}
		}
	}

	public void testAddRemoveExperimentInfo() {
		ExperimentManager expMan = new ExperimentManager();
		try {
			String birnIDStr = "UCSD1A111";
			String expName = "Alzheimer Testbed";
			String researchGroupName = "Alzheimer Subject";

			java.util.Date scanDate = new java.util.Date(System
					.currentTimeMillis());
			String protocolID = "JERNIGAN_SPGR";
			BigDecimal secLabel = new BigDecimal("11000");

			Subjexperiment criteria = new Subjexperiment();
			criteria.setSubjectid(birnIDStr);

			expMan.addExperimentInfo2(con, birnIDStr, // birn ID
					expName, // experimentName
					researchGroupName, new BigDecimal("1"), // visit id
					scanDate, // scan date
					"", // visit description
					Constants.VISIT_TYPE_SCAN, // visit type
					new BigDecimal("1"), // segmentID
					"MRI scan", // segment description
					new BigDecimal("1"), // protocol version
					protocolID, // protocolID
					owner, modUser, secLabel);

			List<ExperimentInfo> expInfos = expMan.getExperimentInfos(con, criteria);
			dumpExpInfos(expInfos);

			expMan.removeExperimentInfo(con, birnIDStr, expName,
					researchGroupName, owner, modUser);

			expInfos = expMan.getExperimentInfos(con, criteria);

			assertTrue(expInfos.isEmpty());
		} catch (Exception x) {
			x.printStackTrace();
			fail(x.getMessage());
		}

	}

	protected void dumpExpInfos(List<ExperimentInfo> expInfos) {
		for (Iterator<ExperimentInfo> iter = expInfos.iterator(); iter.hasNext();) {
			Object item = iter.next();
			System.out.println(item.toString());

		}
	}

	public void testGetExperimentInfos() {
		ExperimentManager expMan = new ExperimentManager();
		try {
			Subjexperiment criteria = new Subjexperiment();
			List<ExperimentInfo> eiList = expMan.getExperimentInfos(con, criteria);
			for (ExperimentInfo ei : eiList) {
				System.out.println(ei);
			}
		} catch (Exception x) {
			x.printStackTrace();
			fail(x.getMessage());
		}
	}

	public static Test suite() throws IOException {
		TestSuite suite = new TestSuite();
		// suite.addTest(new ExpManTest("testGetExperimentInfos",
		// "test.properties"));
		suite.addTest(new ExpManTest("testAddRemoveExperimentInfo",
				"test.properties"));
		return suite;
	}

	public static void main(String[] args) throws IOException {
		junit.textui.TestRunner.run(suite());
	}
}